/*
 * Decompiled with CFR 0.152.
 */
package com.caen.RFIDLibrary;

import com.caen.RFIDLibrary.CAENRFIDEvent;
import com.caen.RFIDLibrary.CAENRFIDEventListener;
import com.caen.RFIDLibrary.CAENRFIDException;
import com.caen.RFIDLibrary.CAENRFIDNotify;
import com.caen.RFIDLibrary.CAENRFIDProtocol;
import com.caen.RFIDLibrary.CAENRFIDTagEventType;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import javax.swing.event.EventListenerList;

public final class CAENRFIDReceiver {
    private Thread myThread;
    private RFIDServer myTCPserver;
    protected EventListenerList listenerList = new EventListenerList();

    public CAENRFIDReceiver(int port) {
        this.myTCPserver = new RFIDServer(port);
        this.myThread = new Thread(this.myTCPserver);
        this.myTCPserver.addCAENRFIDEventListener(new CAENRFIDEventListener(){

            @Override
            public void CAENRFIDTagNotify(CAENRFIDEvent evt) {
                CAENRFIDReceiver.this.rebound(evt);
            }
        });
        this.myThread.start();
    }

    private void rebound(CAENRFIDEvent event) {
        this.fireCAENRFIDEvent(event);
    }

    public void KillServer() {
        this.myTCPserver.KillServer();
    }

    public void addCAENRFIDEventListener(CAENRFIDEventListener listener) {
        this.listenerList.add(CAENRFIDEventListener.class, listener);
    }

    public void removeCAENRFIDEventListener(CAENRFIDEventListener listener) {
        this.listenerList.remove(CAENRFIDEventListener.class, listener);
    }

    private void fireCAENRFIDEvent(CAENRFIDEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != CAENRFIDEventListener.class) continue;
            ((CAENRFIDEventListener)listeners[i + 1]).CAENRFIDTagNotify(evt);
        }
    }

    private class RFIDServer
    implements Runnable {
        private static final int HEADER_SIZE = 10;
        private static final int MAX_CHAR_DESCRIPTION = 30;
        private static final short AVP_REPORTBUFFER = 117;
        private static final short AVP_ADVANCEDREPORTBUFFER = 99;
        private static final short PROTO_ISO180006B = 0;
        private static final short PROTO_EPCC1G1 = 1;
        private static final short PROTO_ISO180006A = 2;
        private static final short PROTO_EPCC1G2 = 3;
        private static final short PROTO_MULTI = 4;
        private static final short PROTO_EPC119 = 5;
        private static final short AVP_KILL = 90;
        private static final short AVP_COMMAND = 1;
        private static final short AVP_RESULT = 2;
        private static final short AVP_EVENTTYPE = 14;
        private static final short AVP_TIMESTAMP = 16;
        private static final short AVP_TAGLENGTH = 15;
        private static final short AVP_TAGTYPE = 18;
        private static final short AVP_TAGID = 17;
        private static final short AVP_SOURCE_NAME = 251;
        private Socket socket;
        private BufferedInputStream inputStream;
        private int Serverport;
        private ByteBuffer IBuffer;
        private boolean loop;
        protected EventListenerList listenerList = new EventListenerList();

        public RFIDServer(int port) {
            this.Serverport = port;
            this.loop = true;
            if (CAENRFIDReceiver.this.myThread != null) {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                CAENRFIDReceiver.this.myThread.interrupt();
            }
        }

        @Deprecated
        public void KillServer() {
            this.loop = false;
            if (CAENRFIDReceiver.this.myThread != null) {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                CAENRFIDReceiver.this.myThread.interrupt();
            }
        }

        private int NBRead(int size) {
            int Result = 0;
            boolean temp_loop = true;
            int a = 0;
            try {
                int start = this.IBuffer.position();
                byte[] tmp = this.IBuffer.array();
                int tmp_size = size;
                while (temp_loop) {
                    a = this.inputStream.read(tmp, start, tmp_size);
                    if (a == -1) {
                        return 0;
                    }
                    start += a;
                    if ((tmp_size -= a) == 0) {
                        this.IBuffer = ByteBuffer.wrap(tmp);
                        temp_loop = false;
                        return 1;
                    }
                    if (a != 0) continue;
                    return -1;
                }
            }
            catch (IOException error) {
                return -1;
            }
            return Result;
        }

        private boolean CheckCommand(short Command) {
            short Result;
            int pos = 0;
            pos = this.IBuffer.position();
            this.IBuffer.position(pos + 2);
            short currentSize = this.IBuffer.getShort();
            currentSize = (short)(currentSize - 6);
            if (currentSize != 2) {
                return false;
            }
            short currentType = this.IBuffer.getShort();
            if (currentType != 1) {
                return false;
            }
            try {
                Result = this.IBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                return false;
            }
            return Result == Command;
        }

        private short getShortAVP(short AVPType) throws CAENRFIDException {
            short Result;
            int pos = this.IBuffer.position();
            this.IBuffer.position(pos + 2);
            short currentSize = this.IBuffer.getShort();
            currentSize = (short)(currentSize - 6);
            if (currentSize != 2) {
                throw new CAENRFIDException("AVP_ERROR");
            }
            short currentType = this.IBuffer.getShort();
            if (currentType != AVPType) {
                this.IBuffer.position(pos);
                throw new CAENRFIDException("AVP_ERROR");
            }
            try {
                Result = this.IBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                this.IBuffer.position(pos);
                throw new CAENRFIDException("AVP_ERROR");
            }
            return Result;
        }

        private int getIntAVP(short AVPType) throws CAENRFIDException {
            int Result;
            int pos = this.IBuffer.position();
            this.IBuffer.position(pos + 2);
            short currentSize = this.IBuffer.getShort();
            currentSize = (short)(currentSize - 6);
            if (currentSize != 4) {
                this.IBuffer.position(pos);
                throw new CAENRFIDException(this.getAVPStatus());
            }
            short currentType = this.IBuffer.getShort();
            if (currentType != AVPType) {
                this.IBuffer.position(pos);
                throw new CAENRFIDException(this.getAVPStatus());
            }
            try {
                Result = this.IBuffer.getInt();
            }
            catch (BufferUnderflowException error) {
                this.IBuffer.position(pos);
                throw new CAENRFIDException(this.getAVPStatus());
            }
            return Result;
        }

        private String getStringAVP(short AVPType, int AVPSize) throws CAENRFIDException {
            byte[] tmp;
            int pos = this.IBuffer.position();
            this.IBuffer.position(pos + 2);
            short currentSize = this.IBuffer.getShort();
            currentSize = (short)(currentSize - 6);
            short currentType = this.IBuffer.getShort();
            if (currentType != AVPType) {
                this.IBuffer.position(pos);
                throw new CAENRFIDException(this.getAVPStatus());
            }
            if (currentSize > AVPSize) {
                this.IBuffer.position(pos);
                throw new CAENRFIDException(this.getAVPStatus());
            }
            try {
                tmp = new byte[currentSize - 1];
                this.IBuffer.get(tmp, 0, currentSize - 1);
            }
            catch (BufferUnderflowException error) {
                this.IBuffer.position(pos);
                throw new CAENRFIDException(this.getAVPStatus());
            }
            String Result = new String(tmp);
            byte[] tmp2 = new byte[1];
            this.IBuffer.get(tmp2, 0, 1);
            return Result;
        }

        private byte[] getDataAVP(short AVPType, int AVPSize) throws CAENRFIDException {
            byte[] Result;
            int pos = this.IBuffer.position();
            this.IBuffer.position(pos + 2);
            short currentSize = this.IBuffer.getShort();
            currentSize = (short)(currentSize - 6);
            short currentType = this.IBuffer.getShort();
            if (currentType != AVPType) {
                this.IBuffer.position(pos);
                throw new CAENRFIDException(this.getAVPStatus());
            }
            if (currentSize > AVPSize) {
                this.IBuffer.position(pos);
                throw new CAENRFIDException(this.getAVPStatus());
            }
            try {
                Result = new byte[currentSize];
                this.IBuffer.get(Result, 0, currentSize);
            }
            catch (BufferUnderflowException error) {
                this.IBuffer.position(pos);
                throw new CAENRFIDException(this.getAVPStatus());
            }
            return Result;
        }

        private String getAVPStatus() {
            String Status;
            int pos = this.IBuffer.position();
            this.IBuffer.position(pos + 2);
            short currentSize = this.IBuffer.getShort();
            currentSize = (short)(currentSize - 6);
            short currentType = this.IBuffer.getShort();
            if (currentType != 2) {
                Status = "Internal Error!";
            } else {
                short status = this.IBuffer.getShort();
                switch (status) {
                    case 0: {
                        Status = "Status_OK";
                        break;
                    }
                    case 100: {
                        Status = "Channel Name exist";
                        break;
                    }
                    case 101: {
                        Status = "Channel address already in use";
                        break;
                    }
                    case 102: {
                        Status = "Unknown Error";
                        break;
                    }
                    case 103: {
                        Status = "Bad Channel";
                        break;
                    }
                    case 104: {
                        Status = "Invalid Source Name";
                        break;
                    }
                    case 105: {
                        Status = "Invalid Channel Name";
                        break;
                    }
                    case 106: {
                        Status = "Too many Channels";
                        break;
                    }
                    case 107: {
                        Status = "Too many Sources";
                        break;
                    }
                    case 109: {
                        Status = "Source not in Channel";
                        break;
                    }
                    case 110: {
                        Status = "Bad timer value";
                        break;
                    }
                    case 111: {
                        Status = "Trigger name exist";
                        break;
                    }
                    case 112: {
                        Status = "Too many Triggers";
                        break;
                    }
                    case 113: {
                        Status = "Bad Trigger";
                        break;
                    }
                    case 114: {
                        Status = "Bad Address";
                        break;
                    }
                    case 115: {
                        Status = "Invalid Protocol";
                        break;
                    }
                    case 116: {
                        Status = "Bad Port Address";
                        break;
                    }
                    case 117: {
                        Status = "Can't connect to server";
                        break;
                    }
                    case 118: {
                        Status = "Invalid Trigger Name";
                        break;
                    }
                    case 119: {
                        Status = "Invalid Time";
                        break;
                    }
                    case 120: {
                        Status = "Source not found";
                        break;
                    }
                    case 121: {
                        Status = "Trigger not found";
                        break;
                    }
                    case 122: {
                        Status = "Channel not found";
                        break;
                    }
                    case 123: {
                        Status = "Bad ReadPoint";
                        break;
                    }
                    case 124: {
                        Status = "Channel busy";
                        break;
                    }
                    case 125: {
                        Status = "Trigger busy";
                        break;
                    }
                    case 126: {
                        Status = "Internal Filesystem error";
                        break;
                    }
                    case 127: {
                        Status = "Invalid Command";
                        break;
                    }
                    case 128: {
                        Status = "Bad Parameter's value";
                        break;
                    }
                    case 200: {
                        Status = "Invalid parameter";
                        break;
                    }
                    case 201: {
                        Status = "Logical Source disabled";
                        break;
                    }
                    case 202: {
                        Status = "Tag not present";
                        break;
                    }
                    case 203: {
                        Status = "Error writing in Tag";
                        break;
                    }
                    case 204: {
                        Status = "Tag Locked";
                        break;
                    }
                    case 205: {
                        Status = "Bad Tag's address";
                        break;
                    }
                    case 206: {
                        Status = "Invalid function";
                        break;
                    }
                    case 207: {
                        Status = "Select/Unselect error";
                        break;
                    }
                    default: {
                        Status = "Generic Error";
                    }
                }
            }
            return Status;
        }

        @Override
        public void run() {
            boolean delsocket = false;
            boolean exit = false;
            String Source = "None";
            String err = "Communication Error";
            int EvtType = 0;
            short length = 12;
            byte[] ID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
            int pos = 0;
            boolean count = false;
            CAENRFIDTagEventType EventType = CAENRFIDTagEventType.TAG_UNKNOWN;
            short tagtype = 0;
            ArrayList<CAENRFIDNotify> NData = new ArrayList<CAENRFIDNotify>();
            CAENRFIDProtocol proto = CAENRFIDProtocol.CAENRFID_MULTYPROTOCOL;
            try {
                ServerSocket Serversocket = new ServerSocket(this.Serverport);
                Serversocket.setSoTimeout(500);
                while (this.loop) {
                    try {
                        this.socket = Serversocket.accept();
                        this.inputStream = new BufferedInputStream(this.socket.getInputStream());
                        while (!exit) {
                            CAENRFIDNotify Notify;
                            byte[] timev;
                            short kill;
                            ArrayList Tags;
                            this.IBuffer = ByteBuffer.allocate(10);
                            int status = this.NBRead(10);
                            if (status < 1) {
                                if (this.loop) continue;
                                exit = true;
                                err = "kill";
                                continue;
                            }
                            this.IBuffer.rewind();
                            short TxVer = this.IBuffer.getShort();
                            short ProgressID = this.IBuffer.getShort();
                            int VendorID = this.IBuffer.getInt();
                            if (TxVer != 1 || ProgressID != 0 || VendorID != 21336) continue;
                            short packLen = this.IBuffer.getShort();
                            this.IBuffer = ByteBuffer.allocate(packLen - 10);
                            status = this.NBRead(packLen - 10);
                            if (status < 1) continue;
                            this.IBuffer.rewind();
                            if (this.CheckCommand((short)117)) {
                                status = -1;
                                Tags = new ArrayList();
                                while (this.IBuffer.position() < this.IBuffer.capacity()) {
                                    switch (status) {
                                        case -1: {
                                            try {
                                                pos = this.IBuffer.position();
                                                kill = this.getShortAVP((short)0);
                                                exit = true;
                                                err = "kill";
                                            }
                                            catch (CAENRFIDException error) {
                                                this.IBuffer.position(pos);
                                                status = 0;
                                            }
                                            break;
                                        }
                                        case 0: {
                                            try {
                                                pos = this.IBuffer.position();
                                                timev = this.getDataAVP((short)16, 8);
                                                status = 1;
                                            }
                                            catch (CAENRFIDException error) {
                                                this.IBuffer.position(pos);
                                                status = 5;
                                            }
                                            break;
                                        }
                                        case 1: {
                                            try {
                                                pos = this.IBuffer.position();
                                                length = this.getShortAVP((short)15);
                                                status = 2;
                                            }
                                            catch (CAENRFIDException error) {
                                                status = 0;
                                            }
                                            break;
                                        }
                                        case 2: {
                                            try {
                                                pos = this.IBuffer.position();
                                                ID = this.getDataAVP((short)17, length);
                                                status = 3;
                                            }
                                            catch (CAENRFIDException error) {
                                                status = 0;
                                            }
                                            break;
                                        }
                                        case 3: {
                                            try {
                                                pos = this.IBuffer.position();
                                                Source = this.getStringAVP((short)251, 30);
                                                status = 4;
                                            }
                                            catch (CAENRFIDException error) {
                                                status = 0;
                                            }
                                            break;
                                        }
                                        case 4: {
                                            try {
                                                pos = this.IBuffer.position();
                                                EvtType = this.getIntAVP((short)14);
                                                switch (EvtType) {
                                                    case 1: {
                                                        EventType = CAENRFIDTagEventType.TAG_GLIMPSED;
                                                        break;
                                                    }
                                                    case 3: {
                                                        EventType = CAENRFIDTagEventType.TAG_OBSERVED;
                                                        break;
                                                    }
                                                    case 4: {
                                                        EventType = CAENRFIDTagEventType.TAG_LOST;
                                                    }
                                                }
                                                Notify = new CAENRFIDNotify(ID, Source, length, EventType);
                                                NData.add(Notify);
                                                status = 0;
                                            }
                                            catch (CAENRFIDException error) {
                                                status = 0;
                                            }
                                            break;
                                        }
                                        case 5: {
                                            err = this.getAVPStatus();
                                        }
                                    }
                                }
                                if (!err.equals("Status_OK")) continue;
                                CAENRFIDEvent evt = new CAENRFIDEvent(NData);
                                this.fireCAENRFIDEvent(evt);
                                continue;
                            }
                            status = -1;
                            Tags = new ArrayList();
                            while (this.IBuffer.position() < this.IBuffer.capacity()) {
                                switch (status) {
                                    case -1: {
                                        try {
                                            pos = this.IBuffer.position();
                                            kill = this.getShortAVP((short)0);
                                            exit = true;
                                            err = "kill";
                                        }
                                        catch (CAENRFIDException error) {
                                            this.IBuffer.position(pos);
                                            status = 0;
                                        }
                                        break;
                                    }
                                    case 0: {
                                        try {
                                            pos = this.IBuffer.position();
                                            length = this.getShortAVP((short)15);
                                            if (length == 0) {
                                                ID = new byte[8];
                                                for (int w = 0; w < 8; ++w) {
                                                    ID[w] = 0;
                                                }
                                                tagtype = 0;
                                                EvtType = 0;
                                                Notify = new CAENRFIDNotify(ID, Source, length, proto, EventType);
                                                NData.add(Notify);
                                                status = 0;
                                                break;
                                            }
                                            status = 1;
                                        }
                                        catch (CAENRFIDException error) {
                                            status = 6;
                                        }
                                        break;
                                    }
                                    case 1: {
                                        try {
                                            pos = this.IBuffer.position();
                                            tagtype = this.getShortAVP((short)18);
                                            switch (tagtype) {
                                                case 0: {
                                                    proto = CAENRFIDProtocol.CAENRFID_ISO18000_6b;
                                                    break;
                                                }
                                                case 1: {
                                                    proto = CAENRFIDProtocol.CAENRFID_EPC_C1G1;
                                                    break;
                                                }
                                                case 2: {
                                                    proto = CAENRFIDProtocol.CAENRFID_ISO18000_6a;
                                                    break;
                                                }
                                                case 3: {
                                                    proto = CAENRFIDProtocol.CAENRFID_EPC_C1G2;
                                                    break;
                                                }
                                                case 4: {
                                                    proto = CAENRFIDProtocol.CAENRFID_MULTYPROTOCOL;
                                                    break;
                                                }
                                                case 5: {
                                                    proto = CAENRFIDProtocol.CAENRFID_EPC119;
                                                }
                                            }
                                            status = 2;
                                        }
                                        catch (CAENRFIDException error) {
                                            status = 0;
                                        }
                                        break;
                                    }
                                    case 2: {
                                        try {
                                            pos = this.IBuffer.position();
                                            ID = this.getDataAVP((short)17, length);
                                            status = 3;
                                        }
                                        catch (CAENRFIDException error) {
                                            status = 0;
                                        }
                                        break;
                                    }
                                    case 3: {
                                        try {
                                            pos = this.IBuffer.position();
                                            EvtType = this.getIntAVP((short)14);
                                            switch (EvtType) {
                                                case 1: {
                                                    EventType = CAENRFIDTagEventType.TAG_GLIMPSED;
                                                    break;
                                                }
                                                case 3: {
                                                    EventType = CAENRFIDTagEventType.TAG_OBSERVED;
                                                    break;
                                                }
                                                case 4: {
                                                    EventType = CAENRFIDTagEventType.TAG_LOST;
                                                }
                                            }
                                            status = 4;
                                        }
                                        catch (CAENRFIDException error) {
                                            status = 0;
                                        }
                                        break;
                                    }
                                    case 4: {
                                        try {
                                            pos = this.IBuffer.position();
                                            Source = this.getStringAVP((short)251, 30);
                                            status = 5;
                                        }
                                        catch (CAENRFIDException error) {
                                            status = 0;
                                        }
                                        break;
                                    }
                                    case 5: {
                                        try {
                                            pos = this.IBuffer.position();
                                            timev = this.getDataAVP((short)16, 8);
                                            Notify = new CAENRFIDNotify(ID, Source, length, proto, EventType);
                                            NData.add(Notify);
                                            status = 0;
                                        }
                                        catch (CAENRFIDException error) {
                                            this.IBuffer.position(pos);
                                            status = 6;
                                        }
                                        break;
                                    }
                                    case 6: {
                                        err = this.getAVPStatus();
                                    }
                                }
                            }
                            if (!err.equals("Status_OK")) continue;
                            CAENRFIDEvent evt = new CAENRFIDEvent(NData);
                            this.fireCAENRFIDEvent(evt);
                        }
                        this.socket.close();
                    }
                    catch (SocketException e1) {
                    }
                    catch (IOException e2) {}
                }
                Serversocket.close();
            }
            catch (IOException e) {
                CAENRFIDReceiver.this.myThread = null;
                this.socket = null;
            }
        }

        public void addCAENRFIDEventListener(CAENRFIDEventListener listener) {
            this.listenerList.add(CAENRFIDEventListener.class, listener);
        }

        public void removeCAENRFIDEventListener(CAENRFIDEventListener listener) {
            this.listenerList.remove(CAENRFIDEventListener.class, listener);
        }

        private void fireCAENRFIDEvent(CAENRFIDEvent evt) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != CAENRFIDEventListener.class) continue;
                ((CAENRFIDEventListener)listeners[i + 1]).CAENRFIDTagNotify(evt);
            }
        }
    }
}

