/*
 * Decompiled with CFR 0.152.
 */
package com.caen.TCPPort;

import com.caen.RFIDLibrary.CAENRFIDException;
import com.caen.TCPPort.TCPPortEvent;
import com.caen.TCPPort.TCPPortEventListener;
import com.caen.TCPPort.TCPPortEventThread;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.TooManyListenersException;
import javax.swing.event.EventListenerList;

public class TCPPort {
    protected Socket mSocket;
    protected TCPPortEventThread mTCPEventThread;
    protected EventListenerList listenerList = new EventListenerList();
    private static final int TIMEOUT = 4000;

    public void connect(String ip, int port) throws IOException {
        this.mSocket = new Socket(ip, port);
        this.mTCPEventThread.start();
    }

    public void addEventListener(TCPPortEventListener listener) throws TooManyListenersException {
        this.listenerList.add(TCPPortEventListener.class, listener);
    }

    public void removeEventListener(TCPPortEventListener listener) {
        this.listenerList.remove(TCPPortEventListener.class, listener);
    }

    public void fireOnDataEvent(TCPPortEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != TCPPortEventListener.class) continue;
            ((TCPPortEventListener)listeners[i + 1]).onDataEvent(evt);
        }
    }

    public InputStream getInputStream() throws IOException {
        return this.mSocket.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.mSocket.getOutputStream();
    }

    public TCPPort() throws IOException {
        this.mTCPEventThread = new TCPPortEventThread(this);
    }

    public void close() throws CAENRFIDException {
        try {
            if (this.mTCPEventThread.getState().equals((Object)Thread.State.NEW)) {
                this.mSocket.close();
                return;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            this.mSocket.close();
            long loop = 4000L;
            this.mTCPEventThread.interrupt();
            while (loop > 0L) {
                try {
                    if (!this.mTCPEventThread.isAlive()) {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        --loop;
                        continue;
                    }
                    loop = -1L;
                }
                catch (NullPointerException err) {
                    loop = -1L;
                }
            }
            if (loop == 0L && !this.mTCPEventThread.getState().equals((Object)Thread.State.TERMINATED)) {
                this.mTCPEventThread.interrupt();
            }
            this.mSocket.close();
        }
        catch (IOException e) {
            throw new CAENRFIDException("@ Reader Busy");
        }
    }
}

