/*
 * Decompiled with CFR 0.152.
 */
package com.caen.RFIDLibrary;

import com.caen.RFIDLibrary.CAENRFIDChannelReservedType;
import com.caen.RFIDLibrary.CAENRFIDException;
import com.caen.RFIDLibrary.CAENRFIDLogicalSource;
import com.caen.RFIDLibrary.CAENRFIDReader;
import com.caen.RFIDLibrary.CAENRFIDTrigger;

public final class CAENRFIDChannel {
    private String Nome;
    private String Host;
    private int Port;
    private CAENRFIDReader MainReader;
    private boolean ValidChannel;
    private CAENRFIDChannelReservedType CType;
    private int MaxSize = 0;

    protected CAENRFIDChannel(CAENRFIDReader Reader, String nome, String host, int port) {
        this.Nome = nome;
        this.Host = host;
        this.Port = port;
        this.CType = CAENRFIDChannelReservedType.StandardChannel;
        this.MaxSize = 0;
        this.MainReader = Reader;
        this.ValidChannel = true;
    }

    protected CAENRFIDChannel(CAENRFIDReader Reader, String nome, CAENRFIDChannelReservedType Type, int MaxBufferSize) {
        this.Nome = nome;
        this.Host = "";
        this.Port = 0;
        this.CType = Type;
        this.MaxSize = MaxBufferSize;
        this.MainReader = Reader;
        this.ValidChannel = true;
    }

    public void AddTrigger(CAENRFIDTrigger trigger) throws CAENRFIDException {
        if (!this.ValidChannel) {
            throw new CAENRFIDException("Invalid Object");
        }
        try {
            this.MainReader.AddNotifyTrigger(this.Nome, trigger.GetName());
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public void RemoveTrigger(CAENRFIDTrigger trigger) throws CAENRFIDException {
        if (!this.ValidChannel) {
            throw new CAENRFIDException("Invalid Object");
        }
        try {
            this.MainReader.RemoveNotifyTrigger(this.Nome, trigger.GetName());
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public void AddSource(CAENRFIDLogicalSource source) throws CAENRFIDException {
        if (!this.ValidChannel) {
            throw new CAENRFIDException("Invalid Object");
        }
        try {
            this.MainReader.AddSourceToChannel(this.Nome, source.GetName());
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public void RemoveSource(CAENRFIDLogicalSource source) throws CAENRFIDException {
        if (!this.ValidChannel) {
            throw new CAENRFIDException("Invalid Object");
        }
        try {
            this.MainReader.RemoveSourceFromChannel(this.Nome, source.GetName());
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public boolean IsSourcePresent(CAENRFIDLogicalSource Source) throws CAENRFIDException {
        short Result;
        if (!this.ValidChannel) {
            throw new CAENRFIDException("Invalid Object");
        }
        try {
            Result = this.MainReader.CheckSourceInChannel(this.Nome, Source.GetName());
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        return Result == 1;
    }

    public boolean IsTriggerPresent(CAENRFIDTrigger Trigger) throws CAENRFIDException {
        short Result;
        if (!this.ValidChannel) {
            throw new CAENRFIDException("Invalid Object");
        }
        try {
            Result = this.MainReader.CheckTriggerInChannel(this.Nome, Trigger.GetName());
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        return Result == 1;
    }

    public String GetName() throws CAENRFIDException {
        if (!this.ValidChannel) {
            throw new CAENRFIDException("Invalid Object");
        }
        return this.Nome;
    }

    public CAENRFIDChannelReservedType GetChannelType() throws CAENRFIDException {
        if (!this.ValidChannel) {
            throw new CAENRFIDException("Invalid Object");
        }
        return this.CType;
    }

    protected void Deallocate() {
        this.ValidChannel = false;
    }

    public boolean GetChannelStatus() throws CAENRFIDException {
        try {
            short res = this.MainReader.GetChannelStatus(this.Nome);
            return res == 1;
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }
}

