/*
 * Decompiled with CFR 0.152.
 */
package com.caen.RFIDLibrary;

import com.caen.RFIDLibrary.CAENRFIDEvent;
import com.caen.RFIDLibrary.CAENRFIDEventListener;
import com.caen.RFIDLibrary.CAENRFIDException;
import com.caen.RFIDLibrary.CAENRFIDLogicalSourceConstants;
import com.caen.RFIDLibrary.CAENRFIDReader;
import com.caen.RFIDLibrary.CAENRFIDSelUnselOptions;
import com.caen.RFIDLibrary.CAENRFIDTag;
import com.caen.RFIDLibrary.CAENRFIDTrigger;
import com.caen.RFIDLibrary.HitachiSysInfo;
import javax.swing.event.EventListenerList;

public final class CAENRFIDLogicalSource {
    private String Name;
    private CAENRFIDReader MainReader;
    private EventListenerList listenerList = new EventListenerList();
    static /* synthetic */ Class class$com$caen$RFIDLibrary$CAENRFIDEventListener;

    protected CAENRFIDLogicalSource(CAENRFIDReader Reader, String nome) {
        this.Name = nome;
        this.MainReader = Reader;
    }

    public void AddReadPoint(String ReadPoint) throws CAENRFIDException {
        try {
            this.MainReader.AddReadPoint(this.Name, ReadPoint);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public void RemoveReadPoint(String ReadPoint) throws CAENRFIDException {
        try {
            this.MainReader.RemoveReadPoint(this.Name, ReadPoint);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public boolean isReadPointPresent(String ReadPoint) throws CAENRFIDException {
        short par;
        try {
            par = this.MainReader.GetReadPointInSource(this.Name, ReadPoint);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        return par == 1;
    }

    public void SetReadCycle(int Value) throws CAENRFIDException {
        try {
            this.MainReader.SetSourceConfiguration(this.Name, 0, Value);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public int GetReadCycle() throws CAENRFIDException {
        int par;
        try {
            par = this.MainReader.GetSourceConfiguration(this.Name, 0);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        return par;
    }

    public void SetObservedThreshold(int Value) throws CAENRFIDException {
        try {
            this.MainReader.SetSourceConfiguration(this.Name, 1, Value);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public int GetObservedThreshold() throws CAENRFIDException {
        int par;
        try {
            par = this.MainReader.GetSourceConfiguration(this.Name, 1);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        return par;
    }

    public void SetLostThreshold(int Value) throws CAENRFIDException {
        try {
            this.MainReader.SetSourceConfiguration(this.Name, 2, Value);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public int GetLostThreshold() throws CAENRFIDException {
        int par;
        try {
            par = this.MainReader.GetSourceConfiguration(this.Name, 2);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        return par;
    }

    public String GetName() {
        return this.Name;
    }

    public void AddTrigger(CAENRFIDTrigger trigger) throws CAENRFIDException {
        try {
            this.MainReader.AddReadTrigger(this.Name, trigger.GetName());
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public void RemoveTrigger(CAENRFIDTrigger trigger) throws CAENRFIDException {
        try {
            this.MainReader.RemoveReadTrigger(this.Name, trigger.GetName());
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public CAENRFIDTag[] Inventory() throws CAENRFIDException {
        CAENRFIDTag[] tags;
        try {
            tags = this.MainReader.Inventory(this.Name);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        return tags;
    }

    public CAENRFIDTag[] InventoryTag() throws CAENRFIDException {
        CAENRFIDTag[] tags;
        try {
            tags = this.MainReader.InventoryTag(this.Name);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        return tags;
    }

    public CAENRFIDTag[] InventoryTag(byte[] Mask, short MaskLength, short Position) throws CAENRFIDException {
        CAENRFIDTag[] tags;
        try {
            tags = this.MainReader.InventoryTag(this.Name, Mask, MaskLength, Position, (short)0);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        return tags;
    }

    public CAENRFIDTag[] InventoryTag(byte[] Mask, short MaskLength, short Position, short Flag) throws CAENRFIDException {
        CAENRFIDTag[] tags;
        try {
            tags = this.MainReader.InventoryTag(this.Name, Mask, MaskLength, Position, Flag);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        return tags;
    }

    public CAENRFIDTag[] InventoryTag(short bank, byte[] Mask, short MaskLength, short Position) throws CAENRFIDException {
        CAENRFIDTag[] tags;
        try {
            tags = this.MainReader.InventoryTag(this.Name, bank, Mask, MaskLength, Position, (short)0);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        return tags;
    }

    public CAENRFIDTag[] InventoryTag(short bank, byte[] Mask, short MaskLength, short Position, short Flag) throws CAENRFIDException {
        CAENRFIDTag[] tags;
        try {
            tags = this.MainReader.InventoryTag(this.Name, bank, Mask, MaskLength, Position, (short)0);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        return tags;
    }

    public boolean EventInventoryTag(byte[] Mask, short MaskLength, short Position, short Flag) throws CAENRFIDException {
        boolean res;
        try {
            res = this.MainReader.EventInventoryTag(this.Name, Mask, MaskLength, Position, Flag);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        return res;
    }

    public CAENRFIDTag[] GetBufferedData() throws CAENRFIDException {
        CAENRFIDTag[] tags;
        try {
            tags = this.MainReader.GetBufferedData(this.Name);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        return tags;
    }

    public byte[] ReadTagData(CAENRFIDTag Tag, short Address, short Length) throws CAENRFIDException {
        byte[] datareads;
        try {
            datareads = this.MainReader.ReadTagData(this.Name, Tag, Address, Length);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        return datareads;
    }

    public byte[] ReadTagData_EPC_C1G2(CAENRFIDTag Tag, short MemBank, short Address, short Length) throws CAENRFIDException {
        byte[] datareads;
        try {
            datareads = this.MainReader.ReadTagData_EPC_C1G2(this.Name, Tag, MemBank, Address, Length);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        return datareads;
    }

    public byte[] ReadTagData_EPC_C1G2(CAENRFIDTag Tag, short MemBank, short Address, short Length, int AccessPassword) throws CAENRFIDException {
        byte[] datareads;
        try {
            datareads = this.MainReader.ReadTagData_EPC_C1G2(this.Name, Tag, MemBank, Address, Length, AccessPassword);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        return datareads;
    }

    public byte[] ReadTagData_EPC_C1G2(short BankMask, short PositionMask, short LengthMask, byte[] Mask, short MemBank, short Address, short Length) throws CAENRFIDException {
        byte[] datareads;
        try {
            datareads = this.MainReader.ReadTagData_EPC_C1G2(this.Name, BankMask, PositionMask, LengthMask, Mask, MemBank, Address, Length);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        return datareads;
    }

    public byte[] ReadTagData_EPC_C1G2(short BankMask, short PositionMask, short LengthMask, byte[] Mask, short MemBank, short Address, short Length, int AccessPassword) throws CAENRFIDException {
        byte[] datareads;
        try {
            datareads = this.MainReader.ReadTagData_EPC_C1G2(this.Name, BankMask, PositionMask, LengthMask, Mask, MemBank, Address, Length, AccessPassword);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        return datareads;
    }

    public void LockBlockPermalock_EPC_C1G2(CAENRFIDTag Tag, short MemBank, short BlockPtr, short BlockRange, byte[] Mask, int AccessPassword) throws CAENRFIDException {
        try {
            this.MainReader.LockBlockPermalock_EPC_C1G2(this.Name, Tag, MemBank, BlockPtr, BlockRange, Mask, AccessPassword);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public byte[] ReadBlockPermalock_EPC_C1G2(CAENRFIDTag Tag, short MemBank, short BlockPtr, short BlockRange, int AccessPassword) throws CAENRFIDException {
        byte[] datareads;
        try {
            datareads = this.MainReader.ReadBlockPermalock_EPC_C1G2(this.Name, Tag, MemBank, BlockPtr, BlockRange, AccessPassword);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        return datareads;
    }

    public void WriteTagData(CAENRFIDTag Tag, short Address, short Length, byte[] Data) throws CAENRFIDException {
        try {
            this.MainReader.WriteTagData(this.Name, Tag, Address, Length, Data);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public void WriteTagData_EPC_C1G2(CAENRFIDTag Tag, short MemBank, short Address, short Length, byte[] Data) throws CAENRFIDException {
        try {
            this.MainReader.WriteTagData_EPC_C1G2(this.Name, Tag, MemBank, Address, Length, Data);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public void WriteTagData_EPC_C1G2(CAENRFIDTag Tag, short MemBank, short Address, short Length, byte[] Data, int AccessPassword) throws CAENRFIDException {
        try {
            this.MainReader.WriteTagData_EPC_C1G2(this.Name, Tag, MemBank, Address, Length, Data, AccessPassword);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public void WriteTagData_EPC_C1G2(short BankMask, short PositionMask, short LengthMask, byte[] Mask, short MemBank, short Address, short Length, byte[] Data) throws CAENRFIDException {
        try {
            this.MainReader.WriteTagData_EPC_C1G2(this.Name, BankMask, PositionMask, LengthMask, Mask, MemBank, Address, Length, Data);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public void WriteTagData_EPC_C1G2(short BankMask, short PositionMask, short LengthMask, byte[] Mask, short MemBank, short Address, short Length, byte[] Data, int AccessPassword) throws CAENRFIDException {
        try {
            this.MainReader.WriteTagData_EPC_C1G2(this.Name, BankMask, PositionMask, LengthMask, Mask, MemBank, Address, Length, Data, AccessPassword);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public void BlockWriteTagData(CAENRFIDTag Tag, short Address, short Length, byte[] Data) throws CAENRFIDException {
        try {
            this.MainReader.BlockWriteTagData(this.Name, Tag, Address, (short)255, Length, Data);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public void BlockWriteTagData(CAENRFIDTag Tag, short Address, short mask, short Length, byte[] Data) throws CAENRFIDException {
        mask = (short)(mask << 4);
        try {
            this.MainReader.BlockWriteTagData(this.Name, Tag, Address, mask, Length, Data);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public void LockTag_ISO180006B(CAENRFIDTag Tag, short Address) throws CAENRFIDException {
        try {
            this.MainReader.LockTag(this.Name, Tag, Address);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public void ProgramID_EPC119(CAENRFIDTag Tag, byte[] NewID) throws CAENRFIDException {
        try {
            this.MainReader.ProgramID_EPC119(this.Name, Tag, NewID);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public void ProgramID_EPC_C1G1(CAENRFIDTag Tag, short Password, boolean Lock) throws CAENRFIDException {
        try {
            this.MainReader.ProgramID_EPC_C1G1(this.Name, Tag, Password, Lock);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public void ProgramID_EPC_C1G2(CAENRFIDTag Tag, short NSI) throws CAENRFIDException {
        try {
            this.MainReader.ProgramID_EPC_C1G2(this.Name, Tag, NSI);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public void KillTag_EPC_C1G1(CAENRFIDTag Tag, short Password) throws CAENRFIDException {
        try {
            this.MainReader.KillTag_EPC_C1G1(this.Name, Tag, Password);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public void KillTag_EPC_C1G2(CAENRFIDTag Tag, int Password) throws CAENRFIDException {
        try {
            this.MainReader.KillTag_EPC_C1G2(this.Name, Tag, Password);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public void KillTag_EPC_C1G2(short BankMask, short PositionMask, short LengthMask, byte[] Mask, int Password) throws CAENRFIDException {
        try {
            this.MainReader.KillTag_EPC_C1G2(this.Name, BankMask, PositionMask, LengthMask, Mask, Password);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public byte[] QueryAck_EPC_C1G2() throws CAENRFIDException {
        byte[] id;
        try {
            id = this.MainReader.QueryAck_EPC_C1G2(this.Name);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        return id;
    }

    public void ProgramID_EPC_C1G2(CAENRFIDTag Tag, short NSI, int AccessPassword) throws CAENRFIDException {
        try {
            this.MainReader.ProgramID_EPC_C1G2(this.Name, Tag, NSI, AccessPassword);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public void LockTag_EPC_C1G2(CAENRFIDTag Tag, int Payload) throws CAENRFIDException {
        try {
            this.MainReader.LockTag_EPC_C1G2(this.Name, Tag, Payload);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public void LockTag_EPC_C1G2(CAENRFIDTag Tag, int Payload, int AccessPassword) throws CAENRFIDException {
        try {
            this.MainReader.LockTag_EPC_C1G2(this.Name, Tag, Payload, AccessPassword);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public void LockTag_EPC_C1G2(short BankMask, short PositionMask, short LengthMask, byte[] Mask, int Payload) throws CAENRFIDException {
        try {
            this.MainReader.LockTag_EPC_C1G2(this.Name, BankMask, PositionMask, LengthMask, Mask, Payload);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public void LockTag_EPC_C1G2(short BankMask, short PositionMask, short LengthMask, byte[] Mask, int Payload, int AccessPassword) throws CAENRFIDException {
        try {
            this.MainReader.LockTag_EPC_C1G2(this.Name, BankMask, PositionMask, LengthMask, Mask, Payload);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public boolean Query_EPC_C1G2() throws CAENRFIDException {
        boolean Res;
        try {
            Res = this.MainReader.Query_EPC_C1G2(this.Name);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        return Res;
    }

    public void SetQ_EPC_C1G2(int Value) throws CAENRFIDException {
        if (Value > 15 || Value < 0) {
            throw new CAENRFIDException("@ Invalid parameter");
        }
        try {
            this.MainReader.SetSourceConfiguration(this.Name, 3, Value);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public int GetQ_EPC_C1G2() throws CAENRFIDException {
        int par;
        try {
            par = this.MainReader.GetSourceConfiguration(this.Name, 3);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        return par;
    }

    public void SetSession_EPC_C1G2(CAENRFIDLogicalSourceConstants Value) throws CAENRFIDException {
        try {
            this.MainReader.SetSourceConfiguration(this.Name, 4, Value.getIntValue());
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public CAENRFIDLogicalSourceConstants GetSession_EPC_C1G2() throws CAENRFIDException {
        try {
            int par = this.MainReader.GetSourceConfiguration(this.Name, 4);
            switch (par) {
                case 0: {
                    return CAENRFIDLogicalSourceConstants.EPC_C1G2_SESSION_S0;
                }
                case 1: {
                    return CAENRFIDLogicalSourceConstants.EPC_C1G2_SESSION_S1;
                }
                case 2: {
                    return CAENRFIDLogicalSourceConstants.EPC_C1G2_SESSION_S2;
                }
                case 3: {
                    return CAENRFIDLogicalSourceConstants.EPC_C1G2_SESSION_S3;
                }
            }
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        return CAENRFIDLogicalSourceConstants.EPC_C1G2_SESSION_S0;
    }

    public void SetTarget_EPC_C1G2(CAENRFIDLogicalSourceConstants Value) throws CAENRFIDException {
        try {
            this.MainReader.SetSourceConfiguration(this.Name, 5, Value.getIntValue());
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public CAENRFIDLogicalSourceConstants GetTarget_EPC_C1G2() throws CAENRFIDException {
        try {
            int par = this.MainReader.GetSourceConfiguration(this.Name, 5);
            switch (par) {
                case 0: {
                    return CAENRFIDLogicalSourceConstants.EPC_C1G2_TARGET_A;
                }
                case 1: {
                    return CAENRFIDLogicalSourceConstants.EPC_C1G2_TARGET_B;
                }
            }
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        return CAENRFIDLogicalSourceConstants.EPC_C1G2_TARGET_A;
    }

    public void SetSelected_EPC_C1G2(CAENRFIDLogicalSourceConstants Value) throws CAENRFIDException {
        try {
            this.MainReader.SetSourceConfiguration(this.Name, 6, Value.getIntValue());
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public CAENRFIDLogicalSourceConstants GetSelected_EPC_C1G2() throws CAENRFIDException {
        try {
            int par = this.MainReader.GetSourceConfiguration(this.Name, 6);
            switch (par) {
                case 0: {
                    return CAENRFIDLogicalSourceConstants.EPC_C1G2_SELECTED_NO;
                }
                case 1: {
                    return CAENRFIDLogicalSourceConstants.EPC_C1G2_SELECTED_YES;
                }
            }
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        return CAENRFIDLogicalSourceConstants.EPC_C1G2_SELECTED_NO;
    }

    public void SetDESB_ISO180006B(CAENRFIDLogicalSourceConstants Value) throws CAENRFIDException {
        try {
            this.MainReader.SetSourceConfiguration(this.Name, 7, Value.getIntValue());
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public CAENRFIDLogicalSourceConstants GetDESB_ISO180006B() throws CAENRFIDException {
        try {
            int par = this.MainReader.GetSourceConfiguration(this.Name, 7);
            switch (par) {
                case 0: {
                    return CAENRFIDLogicalSourceConstants.ISO18006B_DESB_OFF;
                }
                case 1: {
                    return CAENRFIDLogicalSourceConstants.ISO18006B_DESB_ON;
                }
            }
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        return CAENRFIDLogicalSourceConstants.EPC_C1G2_TARGET_A;
    }

    public void ResetSession_EPC_C1G2() throws CAENRFIDException {
        try {
            this.MainReader.ResetSession(this.Name);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public byte[] CustomCommand_EPC_C1G2(CAENRFIDTag Tag, byte SubCmd, short TXLen, byte[] Data, short RXLen) throws CAENRFIDException {
        byte[] datareads;
        try {
            datareads = this.MainReader.CustomCMD_EPC_C1G2(this.Name, Tag, SubCmd, TXLen, Data, RXLen);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        return datareads;
    }

    public byte[] CustomCommand_EPC_C1G2(CAENRFIDTag Tag, byte SubCmd, short TXLen, byte[] Data, short RXLen, int AccessPassword) throws CAENRFIDException {
        byte[] datareads;
        try {
            datareads = this.MainReader.CustomCMD_EPC_C1G2(this.Name, Tag, SubCmd, TXLen, Data, RXLen, AccessPassword);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        return datareads;
    }

    public void NXP_ReadProtect(CAENRFIDTag Tag) throws CAENRFIDException {
        try {
            this.MainReader.NXP_ReadProtect(this.Name, Tag);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public void NXP_ReadProtect(CAENRFIDTag Tag, int AccessPassword) throws CAENRFIDException {
        try {
            this.MainReader.NXP_ReadProtect(this.Name, Tag, AccessPassword);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public void NXP_ResetReadProtect(CAENRFIDTag Tag, int Password) throws CAENRFIDException {
        try {
            this.MainReader.NXP_ResetReadProtect(this.Name, Tag, Password);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public void NXP_ResetReadProtect(CAENRFIDTag Tag, int Password, int AccessPassword) throws CAENRFIDException {
        try {
            this.MainReader.NXP_ResetReadProtect(this.Name, Tag, Password, AccessPassword);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public void NXP_ChangeEAS(CAENRFIDTag Tag, boolean EAS) throws CAENRFIDException {
        try {
            this.MainReader.NXP_ChangeEAS(this.Name, Tag, EAS);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public void NXP_ChangeEAS(CAENRFIDTag Tag, boolean EAS, int AccessPassword) throws CAENRFIDException {
        try {
            this.MainReader.NXP_ChangeEAS(this.Name, Tag, EAS, AccessPassword);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public byte[] NXP_EAS_Alarm() throws CAENRFIDException {
        byte[] datareads;
        byte[] TagID = new byte[]{0};
        try {
            CAENRFIDTag Tag = new CAENRFIDTag(TagID, 1, this);
            datareads = this.MainReader.NXP_EAS_Alarm(this.Name, Tag);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        return datareads;
    }

    public byte[] NXP_EAS_Alarm(CAENRFIDTag Tag, int AccessPassword) throws CAENRFIDException {
        byte[] datareads;
        try {
            datareads = this.MainReader.NXP_EAS_Alarm(this.Name, Tag, AccessPassword);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        return datareads;
    }

    public void NXP_Calibrate(CAENRFIDTag Tag) throws CAENRFIDException {
        try {
            this.MainReader.NXP_Calibrate(this.Name, Tag);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public void NXP_Calibrate(CAENRFIDTag Tag, int AccessPassword) throws CAENRFIDException {
        try {
            this.MainReader.NXP_Calibrate(this.Name, Tag, AccessPassword);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public void NXP_ChangeConfig(CAENRFIDTag Tag, short ConfigWord) throws CAENRFIDException {
        try {
            this.MainReader.NXP_ChangeConfig(this.Name, Tag, ConfigWord);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public void NXP_ChangeConfig(CAENRFIDTag Tag, short ConfigWord, int Password) throws CAENRFIDException {
        try {
            this.MainReader.NXP_ChangeConfig(this.Name, Tag, ConfigWord, Password);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public void Hitachi_ReadLock(CAENRFIDTag Tag, short Payload) throws CAENRFIDException {
        try {
            this.MainReader.Hitachi_ReadLock(this.Name, Tag, Payload);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public void Hitachi_ReadLock(CAENRFIDTag Tag, short Payload, int AccessPassword) throws CAENRFIDException {
        try {
            this.MainReader.Hitachi_ReadLock(this.Name, Tag, Payload, AccessPassword);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public void Hitachi_WriteMultipleWords(CAENRFIDTag Tag, short MemBank, short Address, byte Length, byte[] Data) throws CAENRFIDException {
        try {
            this.MainReader.Hitachi_WriteMultipleWords(this.Name, Tag, MemBank, Address, Length, Data);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public void Hitachi_WriteMultipleWords(CAENRFIDTag Tag, short MemBank, short WordPtr, byte WordCount, byte[] MaskData, int AccessPassword) throws CAENRFIDException {
        try {
            this.MainReader.Hitachi_WriteMultipleWords(this.Name, Tag, MemBank, WordPtr, WordCount, MaskData, AccessPassword);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public void Hitachi_BlockLock(CAENRFIDTag Tag, byte BlockNum, int UserPassword, byte PayLoad) throws CAENRFIDException {
        try {
            this.MainReader.Hitachi_BlockLock(this.Name, Tag, BlockNum, UserPassword, PayLoad);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public void Hitachi_BlockLock(CAENRFIDTag Tag, byte BlockNum, int UserPassword, byte PayLoad, int AccessPassword) throws CAENRFIDException {
        try {
            this.MainReader.Hitachi_BlockLock(this.Name, Tag, BlockNum, UserPassword, PayLoad, AccessPassword);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public void Hitachi_BlockReadLock(CAENRFIDTag Tag, byte BlockNum, int UserPassword, byte PayLoad) throws CAENRFIDException {
        try {
            this.MainReader.Hitachi_BlockReadLock(this.Name, Tag, BlockNum, UserPassword, PayLoad);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public void Hitachi_BlockReadLock(CAENRFIDTag Tag, byte BlockNum, int UserPassword, byte PayLoad, int AccessPassword) throws CAENRFIDException {
        try {
            this.MainReader.Hitachi_BlockReadLock(this.Name, Tag, BlockNum, UserPassword, PayLoad, AccessPassword);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public HitachiSysInfo Hitachi_GetSystemInfo(CAENRFIDTag Tag) throws CAENRFIDException {
        HitachiSysInfo sysinfo = null;
        try {
            byte[] d = this.MainReader.Hitachi_GetSystemInfo(this.Name, Tag);
            short InfoFlag = (short)(d[1] << 8 | d[2]);
            byte Reserved = d[3];
            byte UII = d[4];
            byte TID = d[5];
            byte User = d[6];
            byte SetAttenuateLevel = d[7];
            short BankLock = (short)(d[8] << 8 | d[9]);
            short BlockReadLock = (short)(d[10] << 8 | d[11]);
            short BlockReadWriteLock = (short)(d[12] << 8 | d[13]);
            short BlockWriteLock = (short)(d[14] << 8 | d[15]);
            sysinfo = new HitachiSysInfo(InfoFlag, Reserved, UII, TID, User, SetAttenuateLevel, BankLock, BlockReadLock, BlockReadWriteLock, BlockWriteLock);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        return sysinfo;
    }

    public HitachiSysInfo Hitachi_GetSystemInfo(CAENRFIDTag Tag, int AccessPassword) throws CAENRFIDException {
        HitachiSysInfo sysinfo = null;
        try {
            byte[] d = this.MainReader.Hitachi_GetSystemInfo(this.Name, Tag, AccessPassword);
            short InfoFlag = (short)(d[1] << 8 | d[2]);
            byte Reserved = d[3];
            byte UII = d[4];
            byte TID = d[5];
            byte User = d[6];
            byte SetAttenuateLevel = d[7];
            short BankLock = (short)(d[8] << 8 | d[9]);
            short BlockReadLock = (short)(d[10] << 8 | d[11]);
            short BlockReadWriteLock = (short)(d[12] << 8 | d[13]);
            short BlockWriteLock = (short)(d[14] << 8 | d[15]);
            sysinfo = new HitachiSysInfo(InfoFlag, Reserved, UII, TID, User, SetAttenuateLevel, BankLock, BlockReadLock, BlockReadWriteLock, BlockWriteLock);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        return sysinfo;
    }

    public void Hitachi_SetAttenuate(CAENRFIDTag Tag, byte Level, boolean LevelLock) throws CAENRFIDException {
        try {
            this.MainReader.Hitachi_SetAttenuate(this.Name, Tag, Level, LevelLock);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public void Hitachi_SetAttenuate(CAENRFIDTag Tag, byte Level, boolean LevelLock, int AccessPassword) throws CAENRFIDException {
        try {
            this.MainReader.Hitachi_SetAttenuate(this.Name, Tag, Level, LevelLock, AccessPassword);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public void Fujitsu_Refresh(CAENRFIDTag Tag, byte option) throws CAENRFIDException {
        try {
            this.MainReader.Fujitsu_Refresh(this.Name, Tag, option);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public void Fujitsu_Refresh(CAENRFIDTag Tag, byte Option, int AccessPassword) throws CAENRFIDException {
        try {
            this.MainReader.Fujitsu_Refresh(this.Name, Tag, Option, AccessPassword);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public void Fujitsu_ChgWordLock(CAENRFIDTag Tag, byte MemBank, short WordPtr, byte Payload, int UserPassword) throws CAENRFIDException {
        try {
            this.MainReader.Fujitsu_ChgWordLock(this.Name, Tag, MemBank, WordPtr, Payload, UserPassword);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public void Fujitsu_ChgWordLock(CAENRFIDTag Tag, byte MemBank, short WordPtr, byte Payload, int UserPassword, int AccessPassword) throws CAENRFIDException {
        try {
            this.MainReader.Fujitsu_ChgWordLock(this.Name, Tag, MemBank, WordPtr, Payload, UserPassword, AccessPassword);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public void Fujitsu_ChgBlockLock(CAENRFIDTag Tag, byte BlockGroupPtr, int Payload, int UserPassword) throws CAENRFIDException {
        try {
            this.MainReader.Fujitsu_ChgBlockLock(this.Name, Tag, BlockGroupPtr, Payload, UserPassword);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public void Fujitsu_ChgBlockLock(CAENRFIDTag Tag, byte BlockGroupPtr, int Payload, int UserPassword, int AccessPassword) throws CAENRFIDException {
        try {
            this.MainReader.Fujitsu_ChgBlockLock(this.Name, Tag, BlockGroupPtr, Payload, UserPassword, AccessPassword);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public byte[] Fujitsu_ReadBlockLock(CAENRFIDTag Tag, byte BlockGroupPtr) throws CAENRFIDException {
        try {
            return this.MainReader.Fujitsu_ReadBlockLock(this.Name, Tag, BlockGroupPtr);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public byte[] Fujitsu_ReadBlockLock(CAENRFIDTag Tag, byte BlockGroupPtr, int AccessPassword) throws CAENRFIDException {
        try {
            return this.MainReader.Fujitsu_ReadBlockLock(this.Name, Tag, BlockGroupPtr, AccessPassword);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public void Fujitsu_ChgBlockGroupPassword(CAENRFIDTag Tag, byte BlockGroupPtr, int NewPassword, int OldPassword) throws CAENRFIDException {
        try {
            this.MainReader.Fujitsu_ChgBlockGroupPassword(this.Name, Tag, BlockGroupPtr, NewPassword, OldPassword);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public void Fujitsu_ChgBlockGroupPassword(CAENRFIDTag Tag, byte BlockGroupPtr, int NewPassword, int OldPassword, int AccessPassword) throws CAENRFIDException {
        try {
            this.MainReader.Fujitsu_ChgBlockGroupPassword(this.Name, Tag, BlockGroupPtr, NewPassword, OldPassword, AccessPassword);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public byte Fujitsu_BurstWrite(CAENRFIDTag Tag, byte MemBank, short Address, byte Length, byte[] data) throws CAENRFIDException {
        try {
            return this.MainReader.Fujitsu_BurstWrite(this.Name, Tag, MemBank, Address, Length, data);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public byte Fujitsu_BurstWrite(CAENRFIDTag Tag, byte MemBank, short Address, byte Length, byte[] Data, int AccessPassword) throws CAENRFIDException {
        try {
            return this.MainReader.Fujitsu_BurstWrite(this.Name, Tag, MemBank, Address, Length, Data, AccessPassword);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public byte Fujitsu_BurstErase(CAENRFIDTag Tag, byte MemBank, short Address, byte Length) throws CAENRFIDException {
        try {
            return this.MainReader.Fujitsu_BurstErase(this.Name, Tag, MemBank, Address, Length);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public byte Fujitsu_BurstErase(CAENRFIDTag Tag, byte MemBank, short Address, byte Length, int AccessPassword) throws CAENRFIDException {
        try {
            return this.MainReader.Fujitsu_BurstErase(this.Name, Tag, MemBank, Address, Length, AccessPassword);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public CAENRFIDTag GroupSelUnsel(CAENRFIDSelUnselOptions Code, short Address, short BitMask, byte[] Data) throws CAENRFIDException {
        CAENRFIDTag Tag;
        try {
            Tag = this.MainReader.GroupSelUnsel(this.Name, Code, Address, BitMask, Data);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        return Tag;
    }

    public void addCAENRFIDEventListener(CAENRFIDEventListener listener) {
        this.listenerList.add(class$com$caen$RFIDLibrary$CAENRFIDEventListener == null ? (class$com$caen$RFIDLibrary$CAENRFIDEventListener = CAENRFIDLogicalSource.class$("com.caen.RFIDLibrary.CAENRFIDEventListener")) : class$com$caen$RFIDLibrary$CAENRFIDEventListener, listener);
    }

    public void removeCAENRFIDEventListener(CAENRFIDEventListener listener) {
        this.listenerList.remove(class$com$caen$RFIDLibrary$CAENRFIDEventListener == null ? (class$com$caen$RFIDLibrary$CAENRFIDEventListener = CAENRFIDLogicalSource.class$("com.caen.RFIDLibrary.CAENRFIDEventListener")) : class$com$caen$RFIDLibrary$CAENRFIDEventListener, listener);
    }

    protected void fireCAENRFIDEvent(CAENRFIDEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != (class$com$caen$RFIDLibrary$CAENRFIDEventListener == null ? CAENRFIDLogicalSource.class$("com.caen.RFIDLibrary.CAENRFIDEventListener") : class$com$caen$RFIDLibrary$CAENRFIDEventListener)) continue;
            ((CAENRFIDEventListener)listeners[i + 1]).CAENRFIDTagNotify(evt);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

