/*
 * Decompiled with CFR 0.152.
 */
package com.caen.RFIDLibrary;

import com.caen.RFIDLibrary.CAENRFIDBitRate;
import com.caen.RFIDLibrary.CAENRFIDChannel;
import com.caen.RFIDLibrary.CAENRFIDChannelReservedType;
import com.caen.RFIDLibrary.CAENRFIDEvent;
import com.caen.RFIDLibrary.CAENRFIDEventListener;
import com.caen.RFIDLibrary.CAENRFIDEventMode;
import com.caen.RFIDLibrary.CAENRFIDException;
import com.caen.RFIDLibrary.CAENRFIDLogicalSource;
import com.caen.RFIDLibrary.CAENRFIDNotify;
import com.caen.RFIDLibrary.CAENRFIDPort;
import com.caen.RFIDLibrary.CAENRFIDProtocol;
import com.caen.RFIDLibrary.CAENRFIDRFRegulations;
import com.caen.RFIDLibrary.CAENRFIDRS232Constants;
import com.caen.RFIDLibrary.CAENRFIDReadPointStatus;
import com.caen.RFIDLibrary.CAENRFIDReaderInfo;
import com.caen.RFIDLibrary.CAENRFIDSelUnselOptions;
import com.caen.RFIDLibrary.CAENRFIDTag;
import com.caen.RFIDLibrary.CAENRFIDTagEventType;
import com.caen.RFIDLibrary.CAENRFIDTrigger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.buffers.BufferUnderflowException;
import java.nio.buffers.ByteBuffer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.TooManyListenersException;
import javax.comm.CommPortIdentifier;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import javax.comm.SerialPortEvent;
import javax.comm.SerialPortEventListener;
import javax.comm.UnsupportedCommOperationException;
import javax.swing.event.EventListenerList;

public final class CAENRFIDReader {
    private static final int SOURCES_X_READER = 4;
    private static final int HEADER_SIZE = 10;
    private static final int AVP_HEADERSIZE = 6;
    private static final int COMMAND_SIZE = 8;
    private static final int TIMEOUT = 40000000;
    private static final int MAX_CHAR_DESCRIPTION = 30;
    private static final int MAX_READPOINT_NAME = 5;
    private static final int MAX_FIRMWARE_STRING = 200;
    private static final int HEADER_PID_BYTE_OFFSET = 2;
    private static final int XPC_LENGTH = 4;
    private static final short PROTO_ISO180006B = 0;
    private static final short PROTO_EPCC1G1 = 1;
    private static final short PROTO_ISO180006A = 2;
    private static final short PROTO_EPCC1G2 = 3;
    private static final short PROTO_MULTI = 4;
    private static final short PROTO_EPC119 = 5;
    private static final short RAWREADID_COMMAND = 18;
    private static final short NEWRAWREADID_COMMAND = 19;
    private static final short ADDREADTRIGGER_COMMAND = 63;
    private static final short ADDNOTIFYTRIGGER_COMMAND = 64;
    private static final short REMOVEREADTRIGGER_COMMAND = 65;
    private static final short REMOVENOTIFYTRIGGER_COMMAND = 66;
    private static final short ALLOCATETRIGGER_COMMAND = 73;
    private static final short DEALLOCATETRIGGER_COMMAND = 74;
    private static final short ALLOCATECHANNEL_COMMAND = 83;
    private static final short DEALLOCATECHANNEL_COMMAND = 84;
    private static final short ADDSOURCETOCHANNEL_COMMAND = 93;
    private static final short REMOVESOURCEFROMCHANNEL_COMMAND = 94;
    private static final short ADDREADPOINT_COMMAND = 95;
    private static final short REMOVEREADPOINT_COMMAND = 96;
    private static final short SETPOWER_COMMAND = 100;
    private static final short READTAG_COMMAND = 110;
    private static final short WRITETAG_COMMAND = 111;
    private static final short LOCKTAG_COMMAND = 112;
    private static final short SETMODULATION_COMMAND = 114;
    private static final short GETPOWER_COMMAND = 115;
    private static final short SETPROTOCOL_COMMAND = 116;
    private static final short CHECKREADPOINTSTATE = 118;
    private static final short CHECKSOURCEINCHANNEL_COMMAND = 119;
    private static final short CHECKREADPOINTINSOURCE_COMMAND = 120;
    private static final short GETPROTOCOL_COMMAND = 121;
    private static final short SETNETWORK_COMMAND = 122;
    private static final short DE_SBCTRL_COMMAND = 123;
    private static final short GETFWRELEASE_COMMAND = 124;
    private static final short GETEXBIT_COMMAND = 125;
    private static final short PROGRAMID_COMMAND = 126;
    private static final short KILLTAG_COMMAND = 127;
    private static final short RFONOFF_COMMAND = 128;
    private static final short GETMODULATION_COMMAND = 129;
    private static final short BLOCKWRITETAG_COMMAND = 130;
    private static final short SETRS232_COMMAND = 131;
    private static final short SETDATETIME_COMMAND = 132;
    private static final short GROUPSELUNSEL_COMMAND = 133;
    private static final short GETIO_COMMAND = 134;
    private static final short SETIO_COMMAND = 135;
    private static final short SETIODIRECTION_COMMAND = 136;
    private static final short GETIODIRECTION_COMMAND = 137;
    private static final short SETSOURCECONFIG_COMMAND = 138;
    private static final short GETSOURCECONFIG_COMMAND = 139;
    private static final short GETTRIGGERS_COMMAND = 140;
    private static final short GETCHANNELS_COMMAND = 141;
    private static final short CHECKSOURCEINTRIGGER_COMMAND = 142;
    private static final short CHECKCHANNELINTRIGGER_COMMAND = 144;
    private static final short CHECKTRIGGERINCHANNEL_COMMAND = 143;
    private static final short SETEVENTMODE_COMMAND = 145;
    private static final short GETEVENTMODE_COMMAND = 146;
    private static final short FIRMWAREUPGRADE_COMMAND = 147;
    private static final short EPC119PROGRAMID_COMMAND = 148;
    private static final short G2PROGRAMID_COMMAND = 149;
    private static final short G2READTAG_COMMAND = 150;
    private static final short G2WRITETAG_COMMAND = 151;
    private static final short G2LOCKTAG_COMMAND = 152;
    private static final short G2KILLTAG_COMMAND = 153;
    private static final short G2QUERYTAG_COMMAND = 154;
    private static final short G2SETQ_COMMAND = 155;
    private static final short G2GETQ_COMMAND = 156;
    private static final short G2QUERYACK_COMMAND = 157;
    private static final short GETREADERINFO_COMMAND = 158;
    private static final short SETLBTMODE_COMMAND = 159;
    private static final short GETLBTMODE_COMMAND = 160;
    private static final short SETRFREGULATION_COMMAND = 161;
    private static final short GETRFREGULATION_COMMAND = 162;
    private static final short SETCHANNEL_COMMAND = 163;
    private static final short GETCHANNEL_COMMAND = 164;
    private static final short RESETSESSION_COMMAND = 165;
    private static final short GETCHANNELDATA_COMMAND = 167;
    private static final short G2CUSTOMCMD_COMMAND = 168;
    private static final short GETCHANNELSTATUS_COMMAND = 169;
    private static final short SETREADEROPTIONS = 170;
    private static final short SETADMINPWD_COMMAND = 170;
    private static final short GETBUFFEREDDATA_COMMAND = 176;
    private static final short G2LOCKBLOCKPERMABLOCK_COMMAND = 177;
    private static final short G2READBLOCKPERMABLOCK_COMMAND = 178;
    private static final short CMD_SAVE_SETTINGS_COMMAND = 179;
    private static final short AVP_COMMAND = 1;
    private static final short AVP_RESULT = 2;
    private static final short AVP_EVENTTYPE = 14;
    private static final short AVP_TAGIDLENGTH = 15;
    private static final short AVP_TIMESTAMP = 16;
    private static final short AVP_TAGID = 17;
    private static final short AVP_TAGTYPE = 18;
    private static final short AVP_CHANNEL_NAME = 30;
    private static final short AVP_CHANNEL_ADDRESS = 31;
    private static final short AVP_TRIGGER_NAME = 32;
    private static final short AVP_TRIGGER_TYPE = 33;
    private static final short AVP_READPOINT_NAME = 34;
    private static final short AVP_TAG_VALUE = 77;
    private static final short AVP_TAGADDRESS = 78;
    private static final short AVP_LENGTH = 80;
    private static final short AVP_MODULATION = 81;
    private static final short AVP_GETPOWER = 82;
    private static final short AVP_PROTOCOL_NAME = 84;
    private static final short AVP_READPOINT_STATUS = 86;
    private static final short AVP_BOOLEAN = 87;
    private static final short AVP_IPADDRESS = 88;
    private static final short AVP_IPNETMASK = 89;
    private static final short AVP_IPGATEWAY = 90;
    private static final short AVP_DE_SBENA = 91;
    private static final short AVP_GETFWRELEASE = 92;
    private static final short AVP_EXBIT_STATUS = 93;
    private static final short AVP_EPCPWD = 94;
    private static final short AVP_RFONOFF = 95;
    private static final short AVP_BAUDRATE = 96;
    private static final short AVP_DATABIT = 97;
    private static final short AVP_STOPBITS = 98;
    private static final short AVP_PARITY = 99;
    private static final short AVP_FLOWCONTROL = 100;
    private static final short AVP_DATETIME = 101;
    private static final short AVP_SELUNSEL_OP = 102;
    private static final short AVP_BYTEMASK = 103;
    private static final short AVP_IOREGISTER = 105;
    private static final short AVP_CONFIGPARAMETER = 106;
    private static final short AVP_CONFIGVALUE = 107;
    private static final short AVP_NUMBEROFTRIGGERS = 108;
    private static final short AVP_NUMBEROFCHANNELS = 109;
    private static final short AVP_EVENTMODE = 110;
    private static final short AVP_UPGRADETYPE = 111;
    private static final short AVP_UPGRADEARG = 112;
    private static final short AVP_MEMBANCK = 113;
    private static final short AVP_PAYLOAD = 114;
    private static final short AVP_G2PWD = 115;
    private static final short AVP_G2NSI = 116;
    private static final short AVP_G2Q = 117;
    private static final short AVP_READERINFO = 118;
    private static final short AVP_RF_REGULATION = 119;
    private static final short AVP_RFCHANNEL = 120;
    private static final short AVP_SUBCMD = 121;
    private static final short AVP_RSSI = 122;
    private static final short AVP_XPC = 124;
    private static final short AVP_SETPOWER = 150;
    private static final short AVP_SOURCE_NAME = 251;
    protected static final int CONFIG_READCYCLE = 0;
    protected static final int CONFIG_OBSERVEDTHRESHOLD = 1;
    protected static final int CONFIG_LOSTTHRESHOLD = 2;
    protected static final int CONFIG_G2_Q_VALUE = 3;
    protected static final int CONFIG_G2_SESSION = 4;
    protected static final int CONFIG_G2_TARGET = 5;
    protected static final int CONFIG_G2_SELECTED = 6;
    protected static final int CONFIG_ISO18006B_DESB = 7;
    public static final String Version = "4.2.0";
    private Socket TCPSocket;
    private CAENRFIDPort ConnectionType;
    private OutputStream RS232Out;
    private OutputStream TCPOut;
    private InputStream RS232In;
    private InputStream TCPIn;
    private SerialPort serialPort;
    private IOBuffer Buffer;
    private boolean IsConnected;
    private CAENRFIDLogicalSource[] Sources;
    private static String[] SourceNames = new String[]{"Source_0", "Source_1", "Source_2", "Source_3"};
    private String[] Antenne = new String[]{"Ant0", "Ant1", "Ant2", "Ant3"};
    private Thread ThreadInventoryListener;
    private final Object InventoryMutex = new Object();
    private boolean InventoryInProgress = false;
    protected final Object LoopMutex = new Object();
    protected boolean Loop;
    private boolean Abort = false;
    private final Object AbortMutex = new Object();
    protected EventListenerList listenerList = new EventListenerList();
    static /* synthetic */ Class class$com$caen$RFIDLibrary$CAENRFIDEventListener;

    public CAENRFIDReader() {
        this.Sources = new CAENRFIDLogicalSource[4];
        this.Sources[0] = new CAENRFIDLogicalSource(this, "Source_0");
        this.Sources[1] = new CAENRFIDLogicalSource(this, "Source_1");
        this.Sources[2] = new CAENRFIDLogicalSource(this, "Source_2");
        this.Sources[3] = new CAENRFIDLogicalSource(this, "Source_3");
    }

    public static String[] GetSourceNames() {
        return SourceNames;
    }

    public CAENRFIDTrigger[] GetAllocatedTriggers() throws CAENRFIDException {
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        boolean except = false;
        boolean out = false;
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)140));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)140);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            int total = InPacket.getShortAVP((short)108);
            if (total > 0) {
                CAENRFIDTrigger[] triggers = new CAENRFIDTrigger[total];
                for (int i = 0; i < total; ++i) {
                    String Name = InPacket.getStringAVP((short)32, 30);
                    triggers[i] = new CAENRFIDTrigger(this, Name, 1000);
                }
                String err = InPacket.getAVPStatus();
                if (err.equals("Status_OK")) {
                    return triggers;
                }
                throw new CAENRFIDException(err);
            }
            String err = InPacket.getAVPStatus();
            if (err.equals("Status_OK")) {
                CAENRFIDTrigger[] triggers = new CAENRFIDTrigger[]{};
                return triggers;
            }
            throw new CAENRFIDException(err);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public CAENRFIDChannel[] GetAllocatedChannels() throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)141));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)141);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            int total = InPacket.getShortAVP((short)109);
            if (total > 0) {
                CAENRFIDChannel[] channels = new CAENRFIDChannel[total];
                for (int i = 0; i < total; ++i) {
                    String Name = InPacket.getStringAVP((short)30, 30);
                    channels[i] = new CAENRFIDChannel(this, Name, "Not Implemented", 1);
                }
                String err = InPacket.getAVPStatus();
                if (err.equals("Status_OK")) {
                    return channels;
                }
                throw new CAENRFIDException(err);
            }
            String err = InPacket.getAVPStatus();
            if (err.equals("Status_OK")) {
                CAENRFIDChannel[] channels = new CAENRFIDChannel[]{};
                return channels;
            }
            throw new CAENRFIDException(err);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public String[] GetReadPoints() {
        return this.Antenne;
    }

    public String GetFirmwareRelease() throws CAENRFIDException {
        String err;
        String rel;
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        boolean except = false;
        boolean out = false;
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)124));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)124);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            rel = InPacket.getStringAVP((short)92, 200);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return rel;
        }
        throw new CAENRFIDException(err);
    }

    public CAENRFIDReaderInfo GetReaderInfo() throws CAENRFIDException {
        CAENRFIDReaderInfo info;
        String err;
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        boolean except = false;
        boolean out = false;
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)158));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)158);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            String Sinfo = InPacket.getStringAVP((short)118, 30);
            int indc = Sinfo.indexOf(" ");
            String[] ReaderInfo = new String[]{Sinfo.substring(0, indc), Sinfo.substring(indc, Sinfo.length())};
            err = InPacket.getAVPStatus();
            if (ReaderInfo.length < 2) {
                throw new CAENRFIDException("@ Communication Error");
            }
            info = new CAENRFIDReaderInfo(ReaderInfo[0], ReaderInfo[1]);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return info;
        }
        throw new CAENRFIDException(err);
    }

    public CAENRFIDLogicalSource[] GetSources() {
        return this.Sources;
    }

    public CAENRFIDLogicalSource GetSource(String Source) throws CAENRFIDException {
        if (Source.equals("Source_0")) {
            return this.Sources[0];
        }
        if (Source.equals("Source_1")) {
            return this.Sources[1];
        }
        if (Source.equals("Source_2")) {
            return this.Sources[2];
        }
        if (Source.equals("Source_3")) {
            return this.Sources[3];
        }
        throw new CAENRFIDException("@ Invalid Source Name");
    }

    public void Connect(CAENRFIDPort ConType, String Address) throws CAENRFIDException {
        if (this.IsConnected) {
            throw new CAENRFIDException("Already Connected");
        }
        boolean Status = false;
        this.ConnectionType = ConType;
        if (ConType == CAENRFIDPort.CAENRFID_TCP) {
            try {
                this.TCPSocket = new Socket(Address, 1000);
                this.TCPOut = this.TCPSocket.getOutputStream();
                this.TCPIn = this.TCPSocket.getInputStream();
                this.Buffer = new IOBuffer();
                Status = true;
                this.IsConnected = true;
            }
            catch (IOException error) {
                Status = false;
            }
            if (!Status) {
                try {
                    this.TCPSocket.close();
                }
                catch (IOException errorC) {
                }
                catch (NullPointerException errorN) {
                    // empty catch block
                }
            }
        }
        if (ConType == CAENRFIDPort.CAENRFID_RS232) {
            String AComPort;
            Enumeration portList;
            int AComBaud = 115200;
            int AComStopB = 1;
            int AComDataB = 8;
            int AComParity = 0;
            boolean ok = false;
            try {
                portList = CommPortIdentifier.getPortIdentifiers();
            }
            catch (UnsatisfiedLinkError errrxtx) {
                throw new CAENRFIDException("@ No RS232 native support (install rxtxComm driver?)");
            }
            int cai = 0;
            StringBuilder sb = new StringBuilder();
            ArrayList<String> cargs = new ArrayList<String>();
            for (int indc = 0; indc < Address.length(); ++indc) {
                char ca = Address.charAt(indc);
                if (ca != ':') {
                    sb.append(ca);
                    if (indc != Address.length() - 1) continue;
                    cargs.add(cai, sb.toString());
                    continue;
                }
                cargs.add(cai, sb.toString());
                ++cai;
                sb = new StringBuilder();
            }
            String[] CommArgs = new String[cargs.size()];
            for (int i = 0; i < CommArgs.length; ++i) {
                CommArgs[i] = (String)cargs.get(i);
            }
            switch (CommArgs.length) {
                case 1: {
                    AComPort = CommArgs[0];
                    break;
                }
                case 2: {
                    AComPort = CommArgs[0];
                    AComBaud = Integer.parseInt(CommArgs[1]);
                    break;
                }
                case 3: {
                    AComPort = CommArgs[0];
                    AComBaud = Integer.parseInt(CommArgs[1]);
                    if (CommArgs[2].toUpperCase().equals("N")) {
                        AComParity = 0;
                    }
                    if (CommArgs[2].toUpperCase().equals("E")) {
                        AComParity = 2;
                    }
                    if (CommArgs[2].toUpperCase().equals("M")) {
                        AComParity = 3;
                    }
                    if (CommArgs[2].toUpperCase().equals("O")) {
                        AComParity = 1;
                    }
                    if (!CommArgs[2].toUpperCase().equals("S")) break;
                    AComParity = 4;
                    break;
                }
                case 4: {
                    AComPort = CommArgs[0];
                    AComBaud = Integer.parseInt(CommArgs[1]);
                    if (CommArgs[2].toUpperCase().equals("N")) {
                        AComParity = 0;
                    }
                    if (CommArgs[2].toUpperCase().equals("E")) {
                        AComParity = 2;
                    }
                    if (CommArgs[2].toUpperCase().equals("M")) {
                        AComParity = 3;
                    }
                    if (CommArgs[2].toUpperCase().equals("O")) {
                        AComParity = 1;
                    }
                    if (CommArgs[2].toUpperCase().equals("S")) {
                        AComParity = 4;
                    }
                    AComDataB = Integer.parseInt(CommArgs[3]);
                    break;
                }
                case 5: {
                    AComPort = CommArgs[0];
                    AComBaud = Integer.parseInt(CommArgs[1]);
                    if (CommArgs[2].toUpperCase().equals("N")) {
                        AComParity = 0;
                    }
                    if (CommArgs[2].toUpperCase().equals("E")) {
                        AComParity = 2;
                    }
                    if (CommArgs[2].toUpperCase().equals("M")) {
                        AComParity = 3;
                    }
                    if (CommArgs[2].toUpperCase().equals("O")) {
                        AComParity = 1;
                    }
                    if (CommArgs[2].toUpperCase().equals("S")) {
                        AComParity = 4;
                    }
                    AComDataB = Integer.parseInt(CommArgs[3]);
                    AComStopB = Integer.parseInt(CommArgs[4]);
                    break;
                }
                default: {
                    AComPort = CommArgs[0];
                }
            }
            AComPort = AComPort.concat(":");
            while (portList.hasMoreElements() && !ok) {
                CommPortIdentifier portId = (CommPortIdentifier)portList.nextElement();
                if (portId.getPortType() != 1 || !portId.getName().equals(AComPort.toUpperCase()) && !portId.getName().equals(AComPort.toLowerCase()) && !portId.getName().equals(AComPort)) continue;
                try {
                    this.serialPort = (SerialPort)portId.open("RFID", 2000);
                }
                catch (PortInUseException e) {
                    throw new CAENRFIDException("@ RS232 Port in use");
                }
                ok = true;
            }
            if (!ok) {
                throw new CAENRFIDException("@ RS232 Port Not Found");
            }
            try {
                this.serialPort.setSerialPortParams(AComBaud, AComDataB, AComStopB, AComParity);
            }
            catch (UnsupportedCommOperationException e) {
                throw new CAENRFIDException("@ No RS232 native support (install rxtxComm driver?)");
            }
            try {
                this.RS232Out = this.serialPort.getOutputStream();
            }
            catch (IOException e) {
                throw new CAENRFIDException("@ RS232 Communication Error");
            }
            try {
                this.serialPort.setInputBufferSize(1000);
                this.RS232In = this.serialPort.getInputStream();
            }
            catch (IOException e) {
                throw new CAENRFIDException("@ RS232 Communication Error");
            }
            Status = true;
            this.Buffer = new IOBuffer();
            try {
                this.serialPort.addEventListener((SerialPortEventListener)this.Buffer);
            }
            catch (TooManyListenersException err) {
                throw new CAENRFIDException("@ RS232 Communication Error");
            }
            this.serialPort.notifyOnDataAvailable(true);
            this.IsConnected = true;
        }
        if (ConType == CAENRFIDPort.CAENRFID_USB) {
            // empty if block
        }
        if (ConType == CAENRFIDPort.CAENRFID_RS485) {
            // empty if block
        }
        if (!Status) {
            throw new CAENRFIDException("@ Reader Not Ready");
        }
    }

    public void Disconnect() throws CAENRFIDException {
        int loop = -1;
        if (this.IsConnected) {
            if (this.ConnectionType == CAENRFIDPort.CAENRFID_TCP) {
                try {
                    this.TCPSocket.close();
                    this.IsConnected = false;
                }
                catch (IOException error) {
                    throw new CAENRFIDException("@ Reader Busy");
                }
            }
            if (this.ConnectionType == CAENRFIDPort.CAENRFID_RS232) {
                this.InventoryAbort();
                loop = 400000;
                while (loop > 0) {
                    try {
                        if (this.ThreadInventoryListener.isAlive()) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                            --loop;
                            continue;
                        }
                        loop = -1;
                    }
                    catch (NullPointerException err) {
                        loop = -1;
                    }
                }
                if (loop == 0 && this.ThreadInventoryListener != null) {
                    this.ThreadInventoryListener.interrupt();
                }
                this.serialPort.close();
                this.IsConnected = false;
            }
        }
    }

    public int GetPower() throws CAENRFIDException {
        String err;
        int power;
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)115));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)115);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            power = InPacket.getIntAVP((short)82);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return power;
        }
        throw new CAENRFIDException(err);
    }

    public int GetIO() throws CAENRFIDException {
        String err;
        int IO;
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)134));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)134);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            IO = InPacket.getIntAVP((short)105);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return IO;
        }
        throw new CAENRFIDException(err);
    }

    public void SetIO(int IOValue) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)135));
        size = (short)(size + OutPacket.AddIntAVP((short)105, IOValue));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)135);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    public CAENRFIDBitRate GetBitRate() throws CAENRFIDException {
        String err;
        short modulation;
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)129));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)129);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            modulation = InPacket.getShortAVP((short)81);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            switch (modulation) {
                case 1: {
                    return CAENRFIDBitRate.DSB_ASK_FM0_TX10RX40;
                }
                case 2: {
                    return CAENRFIDBitRate.DSB_ASK_FM0_TX40RX40;
                }
                case 3: {
                    return CAENRFIDBitRate.DSB_ASK_FM0_TX40RX160;
                }
                case 4: {
                    return CAENRFIDBitRate.DSB_ASK_FM0_TX160RX400;
                }
                case 5: {
                    return CAENRFIDBitRate.DSB_ASK_M2_TX40RX160;
                }
                case 6: {
                    return CAENRFIDBitRate.PR_ASK_M4_TX40RX250;
                }
                case 7: {
                    return CAENRFIDBitRate.PR_ASK_M4_TX40RX300;
                }
                case 8: {
                    return CAENRFIDBitRate.PR_ASK_M2_TX40RX250;
                }
                case 10: {
                    return CAENRFIDBitRate.DSB_ASK_M4_TX40RX256;
                }
            }
        } else {
            throw new CAENRFIDException(err);
        }
        return CAENRFIDBitRate.DSB_ASK_FM0_TX10RX40;
    }

    public void FWUpgradeTFTP(String server, String filename) throws CAENRFIDException {
        short size = 10;
        String arg = "";
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        arg = server + ":" + filename;
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)147));
        size = (short)(size + OutPacket.AddShortAVP((short)111, (short)1));
        size = (short)(size + OutPacket.AddStringAVP((short)112, arg));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
    }

    public CAENRFIDProtocol GetProtocol() throws CAENRFIDException {
        String err;
        int protocol;
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        boolean except = false;
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)121));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)121);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            protocol = InPacket.getIntAVP((short)84);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            switch (protocol) {
                case 0: {
                    return CAENRFIDProtocol.CAENRFID_ISO18000_6b;
                }
                case 1: {
                    return CAENRFIDProtocol.CAENRFID_EPC_C1G1;
                }
                case 2: {
                    return CAENRFIDProtocol.CAENRFID_ISO18000_6a;
                }
                case 3: {
                    return CAENRFIDProtocol.CAENRFID_EPC_C1G2;
                }
                case 4: {
                    return CAENRFIDProtocol.CAENRFID_MULTYPROTOCOL;
                }
            }
        } else {
            throw new CAENRFIDException(err);
        }
        return CAENRFIDProtocol.CAENRFID_ISO18000_6b;
    }

    public CAENRFIDEventMode GetEventMode() throws CAENRFIDException {
        String err;
        short EventMode;
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)146));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)146);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            EventMode = InPacket.getShortAVP((short)110);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            switch (EventMode) {
                case 0: {
                    return CAENRFIDEventMode.READCYCLE_MODE;
                }
                case 1: {
                    return CAENRFIDEventMode.TIME_MODE;
                }
                case 2: {
                    return CAENRFIDEventMode.NOEVENT_MODE;
                }
            }
        } else {
            throw new CAENRFIDException(err);
        }
        return CAENRFIDEventMode.READCYCLE_MODE;
    }

    public CAENRFIDTrigger CreateTrigger(String Name, int timer) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        String Address = "";
        Integer tmp = new Integer(timer);
        Address = "Timer:" + tmp.toString();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)73));
        size = (short)(size + OutPacket.AddStringAVP((short)32, Name));
        size = (short)(size + OutPacket.AddStringAVP((short)33, Address));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)73);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (!err.equals("Status_OK")) {
            throw new CAENRFIDException(err);
        }
        CAENRFIDTrigger trigger = new CAENRFIDTrigger(this, Name, timer);
        return trigger;
    }

    public CAENRFIDTrigger CreateTrigger(String Name, int IOLine, int timer) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        String Address = "";
        Integer tmp = new Integer(timer);
        Integer tmp2 = new Integer(IOLine);
        Address = "IOValue:" + tmp2.toString() + ":" + tmp.toString();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)73));
        size = (short)(size + OutPacket.AddStringAVP((short)32, Name));
        size = (short)(size + OutPacket.AddStringAVP((short)33, Address));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)73);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (!err.equals("Status_OK")) {
            throw new CAENRFIDException(err);
        }
        CAENRFIDTrigger trigger = new CAENRFIDTrigger(this, Name, IOLine, timer);
        return trigger;
    }

    public CAENRFIDChannel CreateChannel(String Name, String host, int port) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        String Address = "";
        Integer tmp = new Integer(port);
        Address = "TCP://" + host + ":" + tmp.toString();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)83));
        size = (short)(size + OutPacket.AddStringAVP((short)30, Name));
        size = (short)(size + OutPacket.AddStringAVP((short)31, Address));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)83);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (!err.equals("Status_OK")) {
            throw new CAENRFIDException(err);
        }
        CAENRFIDChannel Channel2 = new CAENRFIDChannel(this, Name, host, port);
        return Channel2;
    }

    public CAENRFIDChannel CreateChannel(String Name, CAENRFIDChannelReservedType Type2, int MaxBuffer) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        String Address = "";
        Integer tmp = new Integer(MaxBuffer);
        Address = Type2.GetType() + ":" + tmp.toString();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)83));
        size = (short)(size + OutPacket.AddStringAVP((short)30, Name));
        size = (short)(size + OutPacket.AddStringAVP((short)31, Address));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)83);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (!err.equals("Status_OK")) {
            throw new CAENRFIDException(err);
        }
        CAENRFIDChannel Channel2 = new CAENRFIDChannel(this, Name, Type2, MaxBuffer);
        return Channel2;
    }

    public void RemoveTrigger(CAENRFIDTrigger Trigger) throws CAENRFIDException {
        String TName;
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        try {
            TName = Trigger.GetName();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException("@ Invalid Object");
        }
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)74));
        size = (short)(size + OutPacket.AddStringAVP((short)32, TName));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)74);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (!err.equals("Status_OK")) {
            throw new CAENRFIDException(err);
        }
        Trigger.Deallocate();
    }

    public void RemoveChannel(CAENRFIDChannel Channel2) throws CAENRFIDException {
        String CName;
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        try {
            CName = Channel2.GetName();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException("@ Invalid Object");
        }
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)84));
        size = (short)(size + OutPacket.AddStringAVP((short)30, CName));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)84);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (!err.equals("Status_OK")) {
            throw new CAENRFIDException(err);
        }
        Channel2.Deallocate();
    }

    public void SetPower(int power) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)100));
        size = (short)(size + OutPacket.AddIntAVP((short)150, power));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)100);
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    public void SetBitRate(CAENRFIDBitRate BitRate) throws CAENRFIDException {
        short size = 10;
        short Modula = 1;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        if (BitRate == CAENRFIDBitRate.DSB_ASK_FM0_TX10RX40) {
            Modula = 1;
        }
        if (BitRate == CAENRFIDBitRate.DSB_ASK_FM0_TX40RX40) {
            Modula = 2;
        }
        if (BitRate == CAENRFIDBitRate.DSB_ASK_FM0_TX40RX160) {
            Modula = 3;
        }
        if (BitRate == CAENRFIDBitRate.DSB_ASK_FM0_TX160RX400) {
            Modula = 4;
        }
        if (BitRate == CAENRFIDBitRate.DSB_ASK_M2_TX40RX160) {
            Modula = 5;
        }
        if (BitRate == CAENRFIDBitRate.PR_ASK_M4_TX40RX250) {
            Modula = 6;
        }
        if (BitRate == CAENRFIDBitRate.PR_ASK_M4_TX40RX300) {
            Modula = 7;
        }
        if (BitRate == CAENRFIDBitRate.PR_ASK_M2_TX40RX250) {
            Modula = 8;
        }
        if (BitRate == CAENRFIDBitRate.DSB_ASK_M4_TX40RX256) {
            Modula = 10;
        }
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)114));
        size = (short)(size + OutPacket.AddShortAVP((short)81, Modula));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)114);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    public void SetProtocol(CAENRFIDProtocol Protocol) throws CAENRFIDException {
        int proto = 0;
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        if (Protocol == CAENRFIDProtocol.CAENRFID_ISO18000_6b) {
            proto = 0;
        }
        if (Protocol == CAENRFIDProtocol.CAENRFID_EPC119) {
            proto = 0;
        }
        if (Protocol == CAENRFIDProtocol.CAENRFID_EPC_C1G1) {
            proto = 1;
        }
        if (Protocol == CAENRFIDProtocol.CAENRFID_ISO18000_6a) {
            proto = 2;
        }
        if (Protocol == CAENRFIDProtocol.CAENRFID_EPC_C1G2) {
            proto = 3;
        }
        if (Protocol == CAENRFIDProtocol.CAENRFID_MULTYPROTOCOL) {
            proto = 4;
        }
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)116));
        size = (short)(size + OutPacket.AddIntAVP((short)84, proto));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)116);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    public void SetEventMode(CAENRFIDEventMode EventMode) throws CAENRFIDException {
        short EventM = 0;
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        if (EventMode == CAENRFIDEventMode.READCYCLE_MODE) {
            EventM = 0;
        }
        if (EventMode == CAENRFIDEventMode.TIME_MODE) {
            EventM = 1;
        }
        if (EventMode == CAENRFIDEventMode.NOEVENT_MODE) {
            EventM = 2;
        }
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)145));
        size = (short)(size + OutPacket.AddShortAVP((short)110, EventM));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)145);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    public CAENRFIDReadPointStatus GetReadPointStatus(String ReadPoint) throws CAENRFIDException {
        String err;
        int status;
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)118));
        size = (short)(size + OutPacket.AddStringAVP((short)34, ReadPoint));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)118);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            status = InPacket.getIntAVP((short)86);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            switch (status) {
                case 0: {
                    return CAENRFIDReadPointStatus.STATUS_GOOD;
                }
                case 1: {
                    return CAENRFIDReadPointStatus.STATUS_POOR;
                }
                case 2: {
                    return CAENRFIDReadPointStatus.STATUS_BAD;
                }
            }
        } else {
            throw new CAENRFIDException(err);
        }
        return CAENRFIDReadPointStatus.STATUS_GOOD;
    }

    public void SetNetwork(String IPAddress, String NetMask, String Gateway) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)122));
        size = (short)(size + OutPacket.AddStringAVP((short)88, IPAddress));
        size = (short)(size + OutPacket.AddStringAVP((short)89, NetMask));
        size = (short)(size + OutPacket.AddStringAVP((short)90, Gateway));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)122);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    public void SetReaderOPtions(short option) throws CAENRFIDException {
    }

    public void SetAdminPassword(int AdminPassword) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)170));
        size = (short)(size + OutPacket.AddIntAVP((short)115, AdminPassword));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)163);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    public void SetDateTime(String DateTime) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)132));
        size = (short)(size + OutPacket.AddStringAVP((short)101, DateTime));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)132);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected CAENRFIDTag[] GetBufferedData(String Source) throws CAENRFIDException {
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        CAENRFIDTag[] TagDetected = null;
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)176));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)176);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            ArrayList tags = InPacket.getIDsAVP(this.GetSource(Source));
            int n = tags.size();
            if (n > 0) {
                TagDetected = new CAENRFIDTag[n];
                for (int i = 0; i < n; ++i) {
                    TagDetected[i] = (CAENRFIDTag)tags.remove(0);
                }
            }
            return TagDetected;
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    protected CAENRFIDTag[] Inventory(String Source) throws CAENRFIDException {
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        CAENRFIDTag[] TagDetected = null;
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)18));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)18);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            ArrayList tags = InPacket.getTagsAVP(this.GetSource(Source));
            int n = tags.size();
            if (n > 0) {
                TagDetected = new CAENRFIDTag[n];
                for (int i = 0; i < n; ++i) {
                    TagDetected[i] = (CAENRFIDTag)tags.remove(0);
                }
            }
            return TagDetected;
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    protected CAENRFIDTag[] InventoryTag(String Source) throws CAENRFIDException {
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        CAENRFIDTag[] TagDetected = null;
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)19));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)19);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            ArrayList tags = InPacket.getIDsAVP(this.GetSource(Source));
            int n = tags.size();
            if (n > 0) {
                TagDetected = new CAENRFIDTag[n];
                for (int i = 0; i < n; ++i) {
                    TagDetected[i] = (CAENRFIDTag)tags.remove(0);
                }
            }
            return TagDetected;
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    protected CAENRFIDTag[] InventoryTag(String Source, byte[] Mask, short MaskLength, short position, short flag) throws CAENRFIDException {
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        CAENRFIDTag[] TagDetected = null;
        boolean rssi = (flag & 1) == 1;
        boolean compact = (flag & 8) == 8;
        boolean TID = (flag & 0x10) == 16;
        boolean XPC = (flag & 0x40) == 64;
        flag = (short)(flag & 0xFF59);
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)19));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)80, MaskLength));
        size = (short)(size + OutPacket.AddDataAVP((short)17, Mask));
        size = (short)(size + OutPacket.AddShortAVP((short)78, position));
        size = (short)(size + OutPacket.AddShortAVP((short)103, flag));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)19);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            ArrayList tags = InPacket.getIDsAVPNew(this.GetSource(Source), compact, rssi, TID, XPC);
            int n = tags.size();
            if (n > 0) {
                TagDetected = new CAENRFIDTag[n];
                for (int i = 0; i < n; ++i) {
                    TagDetected[i] = (CAENRFIDTag)tags.remove(0);
                }
            }
            return TagDetected;
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    protected CAENRFIDTag[] InventoryTag(String Source, short bank, byte[] Mask, short MaskLength, short Position, short flag) throws CAENRFIDException {
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        CAENRFIDTag[] TagDetected = null;
        boolean rssi = (flag & 1) == 1;
        boolean compact = (flag & 8) == 8;
        boolean TID = (flag & 0x10) == 16;
        boolean XPC = (flag & 0x40) == 64;
        flag = (short)(flag & 0xFF59);
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)19));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)113, bank));
        size = (short)(size + OutPacket.AddShortAVP((short)80, MaskLength));
        size = (short)(size + OutPacket.AddDataAVP((short)17, Mask));
        size = (short)(size + OutPacket.AddShortAVP((short)78, Position));
        size = (short)(size + OutPacket.AddShortAVP((short)103, flag));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)19);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            ArrayList tags = InPacket.getIDsAVPNew(this.GetSource(Source), compact, rssi, TID, XPC);
            int n = tags.size();
            if (n > 0) {
                TagDetected = new CAENRFIDTag[n];
                for (int i = 0; i < n; ++i) {
                    TagDetected[i] = (CAENRFIDTag)tags.remove(0);
                }
            }
            return TagDetected;
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean EventInventoryTag(String Source, byte[] Mask, short MaskLength, short position, short flag) throws CAENRFIDException {
        Object object = this.InventoryMutex;
        synchronized (object) {
            if (this.InventoryInProgress) {
                return false;
            }
        }
        short size = 10;
        ArrayList<CAENRFIDNotify> NData = new ArrayList<CAENRFIDNotify>();
        short maskLen = MaskLength;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        boolean rssi = (flag & 1) == 1;
        boolean framed = (flag & 2) == 2;
        boolean continuous = (flag & 4) == 4;
        boolean compact = (flag & 8) == 8;
        boolean TID = (flag & 0x10) == 16;
        boolean EventTrigger = (flag & 0x20) == 32;
        boolean XPC = (flag & 0x40) == 64;
        if (compact && !framed) {
            return false;
        }
        if (continuous && !framed) {
            return false;
        }
        if (!(!EventTrigger || continuous && framed)) {
            return false;
        }
        this.Buffer.SetInventoryPID(headerID);
        size = (short)(size + OutPacket.AddCommand((short)19));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)80, MaskLength));
        size = (short)(size + OutPacket.AddDataAVP((short)17, Mask));
        size = (short)(size + OutPacket.AddShortAVP((short)78, position));
        size = (short)(size + OutPacket.AddShortAVP((short)103, flag));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)19);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        if (!continuous && !framed) {
            try {
                ArrayList tags = InPacket.getIDsAVPNew(this.GetSource(Source), compact, rssi, TID, XPC);
                int n = tags.size();
                if (n > 0) {
                    for (int i = 0; i < n; ++i) {
                        CAENRFIDTag TheTag = (CAENRFIDTag)tags.remove(0);
                        CAENRFIDNotify Notify = new CAENRFIDNotify(TheTag.GetId(), Source, TheTag.GetLength(), CAENRFIDProtocol.CAENRFID_EPC_C1G2, CAENRFIDTagEventType.TAG_GLIMPSED, Calendar.getInstance().getTime(), TheTag.GetRSSI(), TheTag.GetTID(), TheTag.GetReadPoint());
                        NData.add(Notify);
                    }
                }
                CAENRFIDEvent evt = NData.isEmpty() ? null : new CAENRFIDEvent(NData);
                this.fireCAENRFIDEvent(evt);
                NData.clear();
                return true;
            }
            catch (CAENRFIDException error) {
                throw new CAENRFIDException(error.toString());
            }
        }
        this.ThreadInventoryListener = new Thread(new InventoryListener(this, this.GetSource(Source), headerID, framed, rssi, TID, compact, XPC));
        this.ThreadInventoryListener.setName("ThreadInventoryListener");
        this.ThreadInventoryListener.start();
        Object object2 = this.InventoryMutex;
        synchronized (object2) {
            this.InventoryInProgress = true;
        }
        return true;
    }

    public void addCAENRFIDEventListener(CAENRFIDEventListener listener) {
        this.listenerList.add(class$com$caen$RFIDLibrary$CAENRFIDEventListener == null ? (class$com$caen$RFIDLibrary$CAENRFIDEventListener = CAENRFIDReader.class$("com.caen.RFIDLibrary.CAENRFIDEventListener")) : class$com$caen$RFIDLibrary$CAENRFIDEventListener, listener);
    }

    public void removeCAENRFIDEventListener(CAENRFIDEventListener listener) {
        this.listenerList.remove(class$com$caen$RFIDLibrary$CAENRFIDEventListener == null ? (class$com$caen$RFIDLibrary$CAENRFIDEventListener = CAENRFIDReader.class$("com.caen.RFIDLibrary.CAENRFIDEventListener")) : class$com$caen$RFIDLibrary$CAENRFIDEventListener, listener);
    }

    private void fireCAENRFIDEvent(CAENRFIDEvent evt) {
        if (evt == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != (class$com$caen$RFIDLibrary$CAENRFIDEventListener == null ? CAENRFIDReader.class$("com.caen.RFIDLibrary.CAENRFIDEventListener") : class$com$caen$RFIDLibrary$CAENRFIDEventListener)) continue;
            ((CAENRFIDEventListener)listeners[i + 1]).CAENRFIDTagNotify(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void InventoryAbort() {
        boolean InvinProg;
        Object object = this.InventoryMutex;
        synchronized (object) {
            if (this.InventoryInProgress) {
                CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
                OutPacket.addAbort();
                boolean bl = this.Buffer.SendPacket(OutPacket);
            }
        }
        object = this.InventoryMutex;
        synchronized (object) {
            InvinProg = this.InventoryInProgress;
        }
        while (InvinProg) {
            object = this.InventoryMutex;
            synchronized (object) {
                InvinProg = this.InventoryInProgress;
            }
        }
    }

    protected byte[] ReadTagData(String Source, CAENRFIDTag tag, short address, short nbyte) throws CAENRFIDException {
        String err;
        byte[] param;
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)110));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)15, tag.GetLength()));
        size = (short)(size + OutPacket.AddDataAVP((short)17, tag.GetId()));
        size = (short)(size + OutPacket.AddShortAVP((short)78, address));
        size = (short)(size + OutPacket.AddShortAVP((short)80, nbyte));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)110);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            param = InPacket.getDataAVP((short)77, nbyte);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return param;
        }
        throw new CAENRFIDException(err);
    }

    protected void WriteTagData(String Source, CAENRFIDTag tag, short address, short nbyte, byte[] twrite) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)111));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)15, tag.GetLength()));
        size = (short)(size + OutPacket.AddDataAVP((short)17, tag.GetId()));
        size = (short)(size + OutPacket.AddShortAVP((short)78, address));
        size = (short)(size + OutPacket.AddShortAVP((short)80, nbyte));
        size = (short)(size + OutPacket.AddDataAVP((short)77, twrite));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)111);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected void LockTag(String Source, CAENRFIDTag tag, short address) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)112));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)15, tag.GetLength()));
        size = (short)(size + OutPacket.AddDataAVP((short)17, tag.GetId()));
        size = (short)(size + OutPacket.AddShortAVP((short)78, address));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)112);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected void BlockWriteTagData(String Source, CAENRFIDTag tag, short address, short mask, short nbyte, byte[] twrite) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)130));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)15, tag.GetLength()));
        size = (short)(size + OutPacket.AddDataAVP((short)17, tag.GetId()));
        size = (short)(size + OutPacket.AddShortAVP((short)78, address));
        if (mask == 255) {
            mask = (short)240;
        }
        size = (short)(size + OutPacket.AddShortAVP((short)103, mask));
        size = (short)(size + OutPacket.AddShortAVP((short)80, nbyte));
        size = (short)(size + OutPacket.AddDataAVP((short)77, twrite));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)130);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected void ProgramID_EPC_C1G1(String Source, CAENRFIDTag tag, short passwd, boolean lock) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short llock = lock ? (short)1 : 0;
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)126));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)15, tag.GetLength()));
        size = (short)(size + OutPacket.AddDataAVP((short)17, tag.GetId()));
        size = (short)(size + OutPacket.AddShortAVP((short)94, passwd));
        size = (short)(size + OutPacket.AddShortAVP((short)87, llock));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)126);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected void ProgramID_EPC119(String Source, CAENRFIDTag tag, byte[] newID) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)148));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddDataAVP((short)17, tag.GetId()));
        size = (short)(size + OutPacket.AddDataAVP((short)77, newID));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)148);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected void KillTag_EPC_C1G1(String Source, CAENRFIDTag tag, short passwd) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)127));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)15, tag.GetLength()));
        size = (short)(size + OutPacket.AddDataAVP((short)17, tag.GetId()));
        size = (short)(size + OutPacket.AddShortAVP((short)94, passwd));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)127);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected void AddReadPoint(String Source, String Antenna) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)95));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddStringAVP((short)34, Antenna));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)95);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected void RemoveReadPoint(String Source, String Antenna) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)96));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddStringAVP((short)34, Antenna));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)96);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected short GetReadPointInSource(String Source, String Antenna) throws CAENRFIDException {
        String err;
        short present;
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)120));
        size = (short)(size + OutPacket.AddStringAVP((short)34, Antenna));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)120);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            present = InPacket.getShortAVP((short)87);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return present;
        }
        throw new CAENRFIDException(err);
    }

    protected void SetSourceConfiguration(String Source, int ParType, int ParValue) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)138));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddIntAVP((short)106, ParType));
        size = (short)(size + OutPacket.AddIntAVP((short)107, ParValue));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)138);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected int GetSourceConfiguration(String Source, int ParType) throws CAENRFIDException {
        String err;
        int param;
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)139));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddIntAVP((short)106, ParType));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)139);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            param = InPacket.getIntAVP((short)107);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return param;
        }
        throw new CAENRFIDException(err);
    }

    protected void AddNotifyTrigger(String Channel2, String Trigger) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)64));
        size = (short)(size + OutPacket.AddStringAVP((short)30, Channel2));
        size = (short)(size + OutPacket.AddStringAVP((short)32, Trigger));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)64);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected void RemoveNotifyTrigger(String Channel2, String Trigger) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)66));
        size = (short)(size + OutPacket.AddStringAVP((short)30, Channel2));
        size = (short)(size + OutPacket.AddStringAVP((short)32, Trigger));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)66);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected void AddSourceToChannel(String Channel2, String Source) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)93));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddStringAVP((short)30, Channel2));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)93);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected void RemoveSourceFromChannel(String Channel2, String Source) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)94));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddStringAVP((short)30, Channel2));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)94);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected void AddReadTrigger(String Source, String Trigger) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)63));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddStringAVP((short)32, Trigger));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)63);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected void RemoveReadTrigger(String Source, String Trigger) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)65));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddStringAVP((short)32, Trigger));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)65);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected short CheckSourceInChannel(String Channel2, String Source) throws CAENRFIDException {
        String err;
        short param;
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)119));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddStringAVP((short)30, Channel2));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)119);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            param = InPacket.getShortAVP((short)87);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return param;
        }
        throw new CAENRFIDException(err);
    }

    protected short CheckTriggerInChannel(String Channel2, String Trigger) throws CAENRFIDException {
        String err;
        short param;
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)143));
        size = (short)(size + OutPacket.AddStringAVP((short)32, Trigger));
        size = (short)(size + OutPacket.AddStringAVP((short)30, Channel2));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)143);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            param = InPacket.getShortAVP((short)87);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return param;
        }
        throw new CAENRFIDException(err);
    }

    protected short CheckSourceInTrigger(String Trigger, String Source) throws CAENRFIDException {
        String err;
        short param;
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)142));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddStringAVP((short)32, Trigger));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)142);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            param = InPacket.getShortAVP((short)87);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return param;
        }
        throw new CAENRFIDException(err);
    }

    protected short CheckChannelInTrigger(String Trigger, String Channel2) throws CAENRFIDException {
        String err;
        short param;
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)144));
        size = (short)(size + OutPacket.AddStringAVP((short)30, Channel2));
        size = (short)(size + OutPacket.AddStringAVP((short)32, Trigger));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)144);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            param = InPacket.getShortAVP((short)87);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return param;
        }
        throw new CAENRFIDException(err);
    }

    protected byte[] ReadTagData_EPC_C1G2(String Source, CAENRFIDTag tag, short membank, short address, short nbyte) throws CAENRFIDException {
        String err;
        byte[] param;
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)150));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)15, tag.GetLength()));
        size = (short)(size + OutPacket.AddDataAVP((short)17, tag.GetId()));
        size = (short)(size + OutPacket.AddShortAVP((short)113, membank));
        size = (short)(size + OutPacket.AddShortAVP((short)78, address));
        size = (short)(size + OutPacket.AddShortAVP((short)80, nbyte));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)150);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            param = InPacket.getDataAVP((short)77, nbyte);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return param;
        }
        throw new CAENRFIDException(err);
    }

    protected byte[] ReadTagData_EPC_C1G2(String Source, CAENRFIDTag tag, short membank, short address, short nbyte, int SecurePassword) throws CAENRFIDException {
        String err;
        byte[] param;
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)150));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)15, tag.GetLength()));
        size = (short)(size + OutPacket.AddDataAVP((short)17, tag.GetId()));
        size = (short)(size + OutPacket.AddShortAVP((short)113, membank));
        size = (short)(size + OutPacket.AddShortAVP((short)78, address));
        size = (short)(size + OutPacket.AddShortAVP((short)80, nbyte));
        size = (short)(size + OutPacket.AddIntAVP((short)115, SecurePassword));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)150);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            param = InPacket.getDataAVP((short)77, nbyte);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return param;
        }
        throw new CAENRFIDException(err);
    }

    protected byte[] ReadTagData_EPC_C1G2(String Source, short BankMask, short PositionMask, short LengthMask, byte[] Mask, short MemBank, short Address, short Length) throws CAENRFIDException {
        String err;
        byte[] param;
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)150));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)113, BankMask));
        size = (short)(size + OutPacket.AddShortAVP((short)78, PositionMask));
        size = (short)(size + OutPacket.AddShortAVP((short)15, LengthMask));
        size = (short)(size + OutPacket.AddDataAVP((short)17, Mask));
        size = (short)(size + OutPacket.AddShortAVP((short)113, MemBank));
        size = (short)(size + OutPacket.AddShortAVP((short)78, Address));
        size = (short)(size + OutPacket.AddShortAVP((short)80, Length));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)150);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            param = InPacket.getDataAVP((short)77, Length);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return param;
        }
        throw new CAENRFIDException(err);
    }

    protected byte[] ReadTagData_EPC_C1G2(String Source, short BankMask, short PositionMask, short LengthMask, byte[] Mask, short MemBank, short Address, short Length, int AccessPassword) throws CAENRFIDException {
        String err;
        byte[] param;
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)150));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)113, BankMask));
        size = (short)(size + OutPacket.AddShortAVP((short)78, PositionMask));
        size = (short)(size + OutPacket.AddShortAVP((short)15, LengthMask));
        size = (short)(size + OutPacket.AddDataAVP((short)17, Mask));
        size = (short)(size + OutPacket.AddShortAVP((short)113, MemBank));
        size = (short)(size + OutPacket.AddShortAVP((short)78, Address));
        size = (short)(size + OutPacket.AddShortAVP((short)80, Length));
        size = (short)(size + OutPacket.AddIntAVP((short)115, AccessPassword));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)150);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            param = InPacket.getDataAVP((short)77, Length);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return param;
        }
        throw new CAENRFIDException(err);
    }

    protected void WriteTagData_EPC_C1G2(String Source, CAENRFIDTag tag, short membank, short address, short nbyte, byte[] twrite) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)151));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)15, tag.GetLength()));
        size = (short)(size + OutPacket.AddDataAVP((short)17, tag.GetId()));
        size = (short)(size + OutPacket.AddShortAVP((short)113, membank));
        size = (short)(size + OutPacket.AddShortAVP((short)78, address));
        size = (short)(size + OutPacket.AddShortAVP((short)80, nbyte));
        size = (short)(size + OutPacket.AddDataAVP((short)77, twrite));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)151);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected void WriteTagData_EPC_C1G2(String Source, CAENRFIDTag tag, short membank, short address, short nbyte, byte[] twrite, int SecurePassword) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)151));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)15, tag.GetLength()));
        size = (short)(size + OutPacket.AddDataAVP((short)17, tag.GetId()));
        size = (short)(size + OutPacket.AddShortAVP((short)113, membank));
        size = (short)(size + OutPacket.AddShortAVP((short)78, address));
        size = (short)(size + OutPacket.AddShortAVP((short)80, nbyte));
        size = (short)(size + OutPacket.AddDataAVP((short)77, twrite));
        size = (short)(size + OutPacket.AddIntAVP((short)115, SecurePassword));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)151);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected void WriteTagData_EPC_C1G2(String Source, short BankMask, short PositionMask, short LengthMask, byte[] Mask, short MemBank, short Address, short Length, byte[] Data) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)151));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)113, BankMask));
        size = (short)(size + OutPacket.AddShortAVP((short)78, PositionMask));
        size = (short)(size + OutPacket.AddShortAVP((short)15, LengthMask));
        size = (short)(size + OutPacket.AddDataAVP((short)17, Mask));
        size = (short)(size + OutPacket.AddShortAVP((short)113, MemBank));
        size = (short)(size + OutPacket.AddShortAVP((short)78, Address));
        size = (short)(size + OutPacket.AddShortAVP((short)80, Length));
        size = (short)(size + OutPacket.AddDataAVP((short)77, Data));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)151);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected void WriteTagData_EPC_C1G2(String Source, short BankMask, short PositionMask, short LengthMask, byte[] Mask, short MemBank, short Address, short Length, byte[] Data, int AccessPassword) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)151));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)113, BankMask));
        size = (short)(size + OutPacket.AddShortAVP((short)78, PositionMask));
        size = (short)(size + OutPacket.AddShortAVP((short)15, LengthMask));
        size = (short)(size + OutPacket.AddDataAVP((short)17, Mask));
        size = (short)(size + OutPacket.AddShortAVP((short)113, MemBank));
        size = (short)(size + OutPacket.AddShortAVP((short)78, Address));
        size = (short)(size + OutPacket.AddShortAVP((short)80, Length));
        size = (short)(size + OutPacket.AddDataAVP((short)77, Data));
        size = (short)(size + OutPacket.AddIntAVP((short)115, AccessPassword));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)151);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected void LockBlockPermalock_EPC_C1G2(String Source, CAENRFIDTag Tag, short MemBank, short BlockPtr, short BlockRange, byte[] Mask, int AccessPassword) throws CAENRFIDException {
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)177));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)15, Tag.GetLength()));
        size = (short)(size + OutPacket.AddShortAVP((short)113, MemBank));
        size = (short)(size + OutPacket.AddShortAVP((short)78, BlockPtr));
        size = (short)(size + OutPacket.AddShortAVP((short)80, BlockRange));
        size = (short)(size + OutPacket.AddDataAVP((short)77, Mask));
        size = (short)(size + OutPacket.AddIntAVP((short)115, AccessPassword));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)177);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected byte[] ReadBlockPermalock_EPC_C1G2(String Source, CAENRFIDTag Tag, short MemBank, short BlockPtr, short BlockRange, int AccessPassword) throws CAENRFIDException {
        String err;
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        byte[] param = null;
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)178));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)15, Tag.GetLength()));
        size = (short)(size + OutPacket.AddShortAVP((short)113, MemBank));
        size = (short)(size + OutPacket.AddShortAVP((short)78, BlockPtr));
        size = (short)(size + OutPacket.AddShortAVP((short)80, BlockRange));
        size = (short)(size + OutPacket.AddIntAVP((short)115, AccessPassword));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)178);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            param = InPacket.getDataAVP((short)77, BlockRange * 2);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return param;
        }
        throw new CAENRFIDException(err);
    }

    protected void LockTag_EPC_C1G2(String Source, CAENRFIDTag tag, int payload) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)152));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)15, tag.GetLength()));
        size = (short)(size + OutPacket.AddDataAVP((short)17, tag.GetId()));
        size = (short)(size + OutPacket.AddIntAVP((short)114, payload));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)152);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected void LockTag_EPC_C1G2(String Source, CAENRFIDTag tag, int payload, int SecurePassword) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)152));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)15, tag.GetLength()));
        size = (short)(size + OutPacket.AddDataAVP((short)17, tag.GetId()));
        size = (short)(size + OutPacket.AddIntAVP((short)114, payload));
        size = (short)(size + OutPacket.AddIntAVP((short)115, SecurePassword));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)152);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected void LockTag_EPC_C1G2(String Source, short BankMask, short PositionMask, short LengthMask, byte[] Mask, int Payload) throws CAENRFIDException {
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)152));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)113, BankMask));
        size = (short)(size + OutPacket.AddShortAVP((short)78, PositionMask));
        size = (short)(size + OutPacket.AddShortAVP((short)15, LengthMask));
        size = (short)(size + OutPacket.AddDataAVP((short)17, Mask));
        size = (short)(size + OutPacket.AddIntAVP((short)114, Payload));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)152);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected void LockTag_EPC_C1G2(String Source, short BankMask, short PositionMask, short LengthMask, byte[] Mask, int Payload, int AccessPassword) throws CAENRFIDException {
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)152));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)113, BankMask));
        size = (short)(size + OutPacket.AddShortAVP((short)78, PositionMask));
        size = (short)(size + OutPacket.AddShortAVP((short)15, LengthMask));
        size = (short)(size + OutPacket.AddDataAVP((short)17, Mask));
        size = (short)(size + OutPacket.AddIntAVP((short)114, Payload));
        size = (short)(size + OutPacket.AddIntAVP((short)115, AccessPassword));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)152);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected void KillTag_EPC_C1G2(String Source, CAENRFIDTag tag, int password) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)153));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)15, tag.GetLength()));
        size = (short)(size + OutPacket.AddDataAVP((short)17, tag.GetId()));
        size = (short)(size + OutPacket.AddIntAVP((short)115, password));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)153);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected void KillTag_EPC_C1G2(String Source, short BankMask, short PositionMask, short LengthMask, byte[] Mask, int AccessPassword) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)153));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)113, BankMask));
        size = (short)(size + OutPacket.AddShortAVP((short)78, PositionMask));
        size = (short)(size + OutPacket.AddShortAVP((short)15, LengthMask));
        size = (short)(size + OutPacket.AddDataAVP((short)17, Mask));
        size = (short)(size + OutPacket.AddIntAVP((short)115, AccessPassword));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)153);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected void ProgramID_EPC_C1G2(String Source, CAENRFIDTag tag, short nsi) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)149));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)15, tag.GetLength()));
        size = (short)(size + OutPacket.AddDataAVP((short)17, tag.GetId()));
        size = (short)(size + OutPacket.AddShortAVP((short)116, nsi));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)149);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected void ProgramID_EPC_C1G2(String Source, CAENRFIDTag tag, short nsi, int SecurePassword) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)149));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)15, tag.GetLength()));
        size = (short)(size + OutPacket.AddDataAVP((short)17, tag.GetId()));
        size = (short)(size + OutPacket.AddShortAVP((short)116, nsi));
        size = (short)(size + OutPacket.AddIntAVP((short)115, SecurePassword));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)149);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected boolean Query_EPC_C1G2(String Source) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)154));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)154);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        return err.equals("Status_OK");
    }

    protected byte[] QueryAck_EPC_C1G2(String Source) throws CAENRFIDException {
        String err;
        byte[] param;
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)154));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)157);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            short length = (short)(this.Buffer.GetPacketLength() - 10);
            param = InPacket.getDataAVP((short)77, length);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return param;
        }
        throw new CAENRFIDException(err);
    }

    private byte[] CCMD_EPC_C1G2(String Source, CAENRFIDTag Tag, short SubCmd, short Length, byte[] Data, short TRLength) throws CAENRFIDException {
        String err;
        byte[] param;
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        byte[] temp = new byte[]{(byte)SubCmd};
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)168));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)15, Tag.GetLength()));
        size = (short)(size + OutPacket.AddDataAVP((short)17, Tag.GetId()));
        size = (short)(size + OutPacket.AddDataAVP((short)121, temp));
        if (Length != 0) {
            size = (short)(size + OutPacket.AddShortAVP((short)80, Length));
            size = (short)(size + OutPacket.AddDataAVP((short)77, Data));
        }
        size = (short)(size + OutPacket.AddShortAVP((short)80, TRLength));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)168);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            param = InPacket.getDataAVP((short)77, TRLength);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return param;
        }
        throw new CAENRFIDException(err);
    }

    private byte[] CCMD_EPC_C1G2(String Source, CAENRFIDTag Tag, short SubCmd, short Length, byte[] Data, short TRLength, int SecurePassword) throws CAENRFIDException {
        String err;
        byte[] param;
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        byte[] temp = new byte[]{(byte)SubCmd};
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)168));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)15, Tag.GetLength()));
        size = (short)(size + OutPacket.AddDataAVP((short)17, Tag.GetId()));
        size = (short)(size + OutPacket.AddDataAVP((short)121, temp));
        if (Length != 0) {
            size = (short)(size + OutPacket.AddShortAVP((short)80, Length));
            size = (short)(size + OutPacket.AddDataAVP((short)77, Data));
        }
        size = (short)(size + OutPacket.AddShortAVP((short)80, TRLength));
        size = (short)(size + OutPacket.AddIntAVP((short)115, SecurePassword));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)168);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            param = InPacket.getDataAVP((short)77, TRLength);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return param;
        }
        throw new CAENRFIDException(err);
    }

    protected byte[] CustomCMD_EPC_C1G2(String Source, CAENRFIDTag Tag, byte SubCmd, short Length, byte[] Data, short TRLength) throws CAENRFIDException {
        try {
            byte[] param = this.CCMD_EPC_C1G2(Source, Tag, SubCmd, Length, Data, TRLength);
            return param;
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    protected void NXP_ReadProtect(String Source, CAENRFIDTag Tag) throws CAENRFIDException {
        byte[] data = null;
        short cmd = 19;
        short cmdlen = 0;
        short retpktlen = 1;
        try {
            byte[] ret = this.CCMD_EPC_C1G2(Source, Tag, cmd, cmdlen, data, retpktlen);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected void NXP_ReadProtect(String Source, CAENRFIDTag Tag, int SecurePassword) throws CAENRFIDException {
        byte[] data = null;
        short cmd = 19;
        short cmdlen = 0;
        short retpktlen = 1;
        try {
            byte[] ret = this.CCMD_EPC_C1G2(Source, Tag, cmd, cmdlen, data, retpktlen, SecurePassword);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected void NXP_ResetReadProtect(String Source, CAENRFIDTag Tag, int Password) throws CAENRFIDException {
        byte[] data = new byte[4];
        short cmd = 20;
        short cmdlen = 4;
        short retpktlen = 1;
        for (int i = 0; i < 4; ++i) {
            data[i] = (byte)((Password & (0xFF00 ^ 3 - i)) >> 16);
        }
        try {
            byte[] ret = this.CCMD_EPC_C1G2(Source, Tag, cmd, cmdlen, data, retpktlen);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected void NXP_ResetReadProtect(String Source, CAENRFIDTag Tag, int Password, int SecurePassword) throws CAENRFIDException {
        byte[] data = new byte[4];
        short cmd = 20;
        short cmdlen = 4;
        short retpktlen = 1;
        for (int i = 0; i < 4; ++i) {
            data[i] = (byte)((Password & (0xFF00 ^ 3 - i)) >> 16);
        }
        try {
            byte[] ret = this.CCMD_EPC_C1G2(Source, Tag, cmd, cmdlen, data, retpktlen, SecurePassword);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected void NXP_ChangeEAS(String Source, CAENRFIDTag Tag, boolean EAS) throws CAENRFIDException {
        short cmd = 21;
        byte[] data = new byte[1];
        short cmdlen = 1;
        short retpktlen = 1;
        data[0] = EAS ? (byte)1 : 0;
        try {
            byte[] ret = this.CCMD_EPC_C1G2(Source, Tag, cmd, cmdlen, data, retpktlen);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected void NXP_ChangeEAS(String Source, CAENRFIDTag Tag, boolean EAS, int SecurePassword) throws CAENRFIDException {
        short cmd = 15;
        byte[] data = new byte[2];
        short cmdlen = 2;
        short retpktlen = 0;
        data[1] = EAS ? (byte)1 : 0;
        data[0] = 0;
        try {
            byte[] ret = this.CCMD_EPC_C1G2(Source, Tag, cmd, cmdlen, data, retpktlen, SecurePassword);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected byte[] NXP_EAS_Alarm(String Source, CAENRFIDTag Tag) throws CAENRFIDException {
        short cmd = 16;
        byte[] data = null;
        short cmdlen = 0;
        short retpktlen = 8;
        try {
            byte[] ret = this.CCMD_EPC_C1G2(Source, Tag, cmd, cmdlen, data, retpktlen);
            return ret;
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected byte[] NXP_EAS_Alarm(String Source, CAENRFIDTag Tag, int SecurePassword) throws CAENRFIDException {
        short cmd = 16;
        byte[] data = null;
        short cmdlen = 0;
        short retpktlen = 8;
        try {
            byte[] ret = this.CCMD_EPC_C1G2(Source, Tag, cmd, cmdlen, data, retpktlen, SecurePassword);
            return ret;
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected void NXP_Calibrate(String Source, CAENRFIDTag Tag) throws CAENRFIDException {
        byte[] data = null;
        short cmd = 23;
        short cmdlen = 0;
        short retpktlen = 1;
        try {
            byte[] ret = this.CCMD_EPC_C1G2(Source, Tag, cmd, cmdlen, data, retpktlen);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected void NXP_Calibrate(String Source, CAENRFIDTag Tag, int SecurePassword) throws CAENRFIDException {
        byte[] data = null;
        short cmd = 23;
        short cmdlen = 0;
        short retpktlen = 1;
        try {
            byte[] ret = this.CCMD_EPC_C1G2(Source, Tag, cmd, cmdlen, data, retpktlen, SecurePassword);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected void NXP_ChangeConfig(String Source, CAENRFIDTag Tag, short ConfigWord) throws CAENRFIDException {
        int cmd = 18;
        byte[] data = new byte[2];
        short cmdlen = 2;
        short retpktlen = 0;
        data[1] = (byte)(ConfigWord >> 8);
        data[0] = (byte)(ConfigWord >> 0);
        try {
            byte[] ret = this.CCMD_EPC_C1G2(Source, Tag, (short)cmd, cmdlen, data, retpktlen);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected void NXP_ChangeConfig(String Source, CAENRFIDTag Tag, short ConfigWord, int SecurePassword) throws CAENRFIDException {
        int cmd = 18;
        byte[] data = new byte[2];
        short cmdlen = 2;
        short retpktlen = 0;
        data[1] = (byte)(ConfigWord >> 8);
        data[0] = (byte)(ConfigWord >> 0);
        try {
            byte[] ret = this.CCMD_EPC_C1G2(Source, Tag, (short)cmd, cmdlen, data, retpktlen, SecurePassword);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected void Hitachi_ReadLock(String Source, CAENRFIDTag Tag, short Payload) throws CAENRFIDException {
        byte[] data = new byte[2];
        short cmd = 0;
        short cmdlen = 2;
        data[0] = (byte)((Payload & 0xFF00) >> 8);
        data[1] = (byte)(Payload & 0xFF);
        short retpktlen = 1;
        try {
            byte[] ret = this.CCMD_EPC_C1G2(Source, Tag, cmd, cmdlen, data, retpktlen);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected void Hitachi_ReadLock(String Source, CAENRFIDTag Tag, short Payload, int SecurePassword) throws CAENRFIDException {
        byte[] data = new byte[2];
        short cmd = 0;
        short cmdlen = 2;
        data[0] = (byte)((Payload & 0xFF00) >> 8);
        data[1] = (byte)(Payload & 0xFF);
        short retpktlen = 1;
        try {
            byte[] ret = this.CCMD_EPC_C1G2(Source, Tag, cmd, cmdlen, data, retpktlen, SecurePassword);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected void Hitachi_WriteMultipleWords(String Source, CAENRFIDTag Tag, short MemBank, short WordPtr, byte WordCount, byte[] MaskData) throws CAENRFIDException {
        short cmd = 1;
        short cmdlen = 4;
        byte[] data = new byte[cmdlen + WordCount];
        short retpktlen = 0;
        data[0] = (byte)MemBank;
        data[1] = (byte)((WordPtr & 0xFF00) >> 8);
        data[2] = (byte)(WordPtr & 0xFF);
        data[3] = WordCount;
        for (int i = 0; i < WordCount; ++i) {
            data[i + 4] = MaskData[i];
        }
        try {
            byte[] ret = this.CCMD_EPC_C1G2(Source, Tag, cmd, cmdlen, data, retpktlen);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected void Hitachi_WriteMultipleWords(String Source, CAENRFIDTag Tag, short MemBank, short WordPtr, byte WordCount, byte[] MaskData, int SecurePassword) throws CAENRFIDException {
        short cmd = 1;
        short cmdlen = 4;
        byte[] data = new byte[cmdlen + WordCount];
        short retpktlen = 0;
        data[0] = (byte)MemBank;
        data[1] = (byte)((WordPtr & 0xFF00) >> 8);
        data[2] = (byte)(WordPtr & 0xFF);
        data[3] = WordCount;
        for (int i = 0; i < WordCount; ++i) {
            data[i + 4] = MaskData[i];
        }
        try {
            byte[] ret = this.CCMD_EPC_C1G2(Source, Tag, cmd, cmdlen, data, retpktlen, SecurePassword);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected void Hitachi_BlockLock(String Source, CAENRFIDTag Tag, byte BlockNum, int Password, byte PayLoad) throws CAENRFIDException {
        short cmd = 2;
        short cmdlen = 6;
        byte[] data = new byte[cmdlen];
        short retpktlen = 0;
        data[0] = BlockNum;
        data[1] = (byte)((Password & 0xFF000000) >> 24);
        data[2] = (byte)((Password & 0xFF0000) >> 16);
        data[3] = (byte)((Password & 0xFF00) >> 8);
        data[4] = (byte)(Password & 0xFF);
        data[5] = PayLoad;
        try {
            byte[] ret = this.CCMD_EPC_C1G2(Source, Tag, cmd, cmdlen, data, retpktlen);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected void Hitachi_BlockLock(String Source, CAENRFIDTag Tag, byte BlockNum, int Password, byte PayLoad, int SecurePassword) throws CAENRFIDException {
        short cmd = 2;
        short cmdlen = 6;
        byte[] data = new byte[cmdlen];
        short retpktlen = 0;
        data[0] = BlockNum;
        data[1] = (byte)((Password & 0xFF000000) >> 24);
        data[2] = (byte)((Password & 0xFF0000) >> 16);
        data[3] = (byte)((Password & 0xFF00) >> 8);
        data[4] = (byte)(Password & 0xFF);
        data[5] = PayLoad;
        try {
            byte[] ret = this.CCMD_EPC_C1G2(Source, Tag, cmd, cmdlen, data, retpktlen, SecurePassword);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected void Hitachi_BlockReadLock(String Source, CAENRFIDTag Tag, byte BlockNum, int Password, byte PayLoad) throws CAENRFIDException {
        short cmd = 3;
        short cmdlen = 6;
        byte[] data = new byte[cmdlen];
        short retpktlen = 1;
        data[0] = BlockNum;
        data[1] = (byte)((Password & 0xFF000000) >> 24);
        data[2] = (byte)((Password & 0xFF0000) >> 16);
        data[3] = (byte)((Password & 0xFF00) >> 8);
        data[4] = (byte)(Password & 0xFF);
        data[5] = PayLoad;
        try {
            byte[] ret = this.CCMD_EPC_C1G2(Source, Tag, cmd, cmdlen, data, retpktlen);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected void Hitachi_BlockReadLock(String Source, CAENRFIDTag Tag, byte BlockNum, int Password, byte PayLoad, int SecurePassword) throws CAENRFIDException {
        short cmd = 3;
        short cmdlen = 6;
        byte[] data = new byte[cmdlen];
        short retpktlen = 1;
        data[0] = BlockNum;
        data[1] = (byte)((Password & 0xFF000000) >> 24);
        data[2] = (byte)((Password & 0xFF0000) >> 16);
        data[3] = (byte)((Password & 0xFF00) >> 8);
        data[4] = (byte)(Password & 0xFF);
        data[5] = PayLoad;
        try {
            byte[] ret = this.CCMD_EPC_C1G2(Source, Tag, cmd, cmdlen, data, retpktlen, SecurePassword);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected byte[] Hitachi_GetSystemInfo(String Source, CAENRFIDTag Tag) throws CAENRFIDException {
        short cmd = 4;
        byte[] data = null;
        short cmdlen = 2;
        data = new byte[cmdlen];
        short retpktlen = 16;
        try {
            byte[] ret = this.CCMD_EPC_C1G2(Source, Tag, cmd, cmdlen, data, retpktlen);
            return ret;
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected byte[] Hitachi_GetSystemInfo(String Source, CAENRFIDTag Tag, int SecurePassword) throws CAENRFIDException {
        short cmd = 4;
        byte[] data = null;
        short cmdlen = 2;
        data = new byte[cmdlen];
        short retpktlen = 16;
        try {
            byte[] ret = this.CCMD_EPC_C1G2(Source, Tag, cmd, cmdlen, data, retpktlen, SecurePassword);
            return ret;
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected void Hitachi_SetAttenuate(String Source, CAENRFIDTag Tag, byte level, boolean lock) throws CAENRFIDException {
        short cmd = 5;
        short cmdlen = 2;
        byte[] data = new byte[cmdlen];
        short retpktlen = 0;
        data[0] = level;
        data[1] = lock ? (byte)1 : 0;
        try {
            byte[] ret = this.CCMD_EPC_C1G2(Source, Tag, cmd, cmdlen, data, retpktlen);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected void Hitachi_SetAttenuate(String Source, CAENRFIDTag Tag, byte level, boolean lock, int SecurePassword) throws CAENRFIDException {
        short cmd = 5;
        short cmdlen = 2;
        byte[] data = new byte[cmdlen];
        short retpktlen = 0;
        data[0] = level;
        data[1] = lock ? (byte)1 : 0;
        try {
            byte[] ret = this.CCMD_EPC_C1G2(Source, Tag, cmd, cmdlen, data, retpktlen, SecurePassword);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected byte[] CustomCMD_EPC_C1G2(String Source, CAENRFIDTag Tag, byte SubCmd, short Length, byte[] Data, short TRLength, int SecurePassword) throws CAENRFIDException {
        try {
            byte[] param = this.CCMD_EPC_C1G2(Source, Tag, SubCmd, Length, Data, TRLength, SecurePassword);
            return param;
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    protected void Fujitsu_Refresh(String Source, CAENRFIDTag Tag, byte option) throws CAENRFIDException {
        byte subcmd = 6;
        short cmdlen = 2;
        short retpktlen = 0;
        byte[] data = new byte[cmdlen];
        data[0] = 0;
        data[1] = option;
        try {
            byte[] TRData = this.CustomCMD_EPC_C1G2(Source, Tag, subcmd, cmdlen, data, retpktlen);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    protected void Fujitsu_Refresh(String Source, CAENRFIDTag Tag, byte option, int SecurePassword) throws CAENRFIDException {
        byte subcmd = 6;
        short cmdlen = 2;
        short retpktlen = 0;
        byte[] data = new byte[cmdlen];
        data[0] = 0;
        data[1] = option;
        try {
            byte[] TRData = this.CustomCMD_EPC_C1G2(Source, Tag, subcmd, cmdlen, data, retpktlen, SecurePassword);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    protected void Fujitsu_ChgWordLock(String Source, CAENRFIDTag Tag, byte MemBank, short WordPtr, byte Payload, int UserPassword) throws CAENRFIDException {
        byte subcmd = 7;
        short cmdlen = 8;
        short retpktlen = 0;
        byte[] data = new byte[cmdlen];
        data[0] = (byte)((WordPtr & 0xFF00) >> 8);
        data[1] = (byte)(WordPtr & 0xFF);
        data[2] = 0;
        data[3] = Payload;
        data[4] = (byte)((UserPassword & 0xFF000000) >> 24);
        data[5] = (byte)((UserPassword & 0xFF0000) >> 16);
        data[6] = (byte)((UserPassword & 0xFF00) >> 8);
        data[7] = (byte)(UserPassword & 0xFF);
        try {
            byte[] TRData = this.CustomCMD_EPC_C1G2(Source, Tag, subcmd, cmdlen, data, retpktlen);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    protected void Fujitsu_ChgWordLock(String Source, CAENRFIDTag Tag, byte MemBank, short WordPtr, byte Payload, int UserPassword, int SecurePassword) throws CAENRFIDException {
        byte subcmd = 7;
        short cmdlen = 8;
        short retpktlen = 0;
        byte[] data = new byte[cmdlen];
        data[0] = (byte)((WordPtr & 0xFF00) >> 8);
        data[1] = (byte)(WordPtr & 0xFF);
        data[2] = 0;
        data[3] = Payload;
        data[4] = (byte)((UserPassword & 0xFF000000) >> 24);
        data[5] = (byte)((UserPassword & 0xFF0000) >> 16);
        data[6] = (byte)((UserPassword & 0xFF00) >> 8);
        data[7] = (byte)(UserPassword & 0xFF);
        try {
            byte[] TRData = this.CustomCMD_EPC_C1G2(Source, Tag, subcmd, cmdlen, data, retpktlen, SecurePassword);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    protected void Fujitsu_ChgBlockLock(String Source, CAENRFIDTag Tag, byte BlockGroupPtr, int Payload, int UserPassword, int SecurePassword) throws CAENRFIDException {
        byte subcmd = 8;
        short cmdlen = 10;
        short retpktlen = 0;
        byte[] data = new byte[cmdlen];
        data[0] = 0;
        data[1] = BlockGroupPtr;
        data[2] = (byte)((Payload & 0xFF000000) >> 24);
        data[3] = (byte)((Payload & 0xFF0000) >> 16);
        data[4] = (byte)((Payload & 0xFF00) >> 8);
        data[5] = (byte)(Payload & 0xFF);
        data[6] = (byte)((UserPassword & 0xFF000000) >> 24);
        data[7] = (byte)((UserPassword & 0xFF0000) >> 16);
        data[8] = (byte)((UserPassword & 0xFF00) >> 8);
        data[9] = (byte)(UserPassword & 0xFF);
        try {
            byte[] TRData = this.CustomCMD_EPC_C1G2(Source, Tag, subcmd, cmdlen, data, retpktlen, SecurePassword);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    protected void Fujitsu_ChgBlockLock(String Source, CAENRFIDTag Tag, byte BlockGroupPtr, int Payload, int UserPassword) throws CAENRFIDException {
        byte subcmd = 8;
        short cmdlen = 10;
        short retpktlen = 0;
        byte[] data = new byte[cmdlen];
        data[0] = 0;
        data[1] = BlockGroupPtr;
        data[2] = (byte)((Payload & 0xFF000000) >> 24);
        data[3] = (byte)((Payload & 0xFF0000) >> 16);
        data[4] = (byte)((Payload & 0xFF00) >> 8);
        data[5] = (byte)(Payload & 0xFF);
        data[6] = (byte)((UserPassword & 0xFF000000) >> 24);
        data[7] = (byte)((UserPassword & 0xFF0000) >> 16);
        data[8] = (byte)((UserPassword & 0xFF00) >> 8);
        data[9] = (byte)(UserPassword & 0xFF);
        try {
            byte[] TRData = this.CustomCMD_EPC_C1G2(Source, Tag, subcmd, cmdlen, data, retpktlen);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    protected byte[] Fujitsu_ReadBlockLock(String Source, CAENRFIDTag Tag, byte BlockGroupPtr) throws CAENRFIDException {
        byte subcmd = 9;
        short cmdlen = 2;
        short retpktlen = 2;
        byte[] data = new byte[cmdlen];
        data[0] = 0;
        data[1] = BlockGroupPtr;
        try {
            byte[] TRData = this.CustomCMD_EPC_C1G2(Source, Tag, subcmd, cmdlen, data, retpktlen);
            return TRData;
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    protected byte[] Fujitsu_ReadBlockLock(String Source, CAENRFIDTag Tag, byte BlockGroupPtr, int SecurePassword) throws CAENRFIDException {
        byte subcmd = 9;
        short cmdlen = 2;
        short retpktlen = 2;
        byte[] data = new byte[cmdlen];
        data[0] = 0;
        data[1] = BlockGroupPtr;
        try {
            byte[] TRData = this.CustomCMD_EPC_C1G2(Source, Tag, subcmd, cmdlen, data, retpktlen, SecurePassword);
            return TRData;
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    protected void Fujitsu_ChgBlockGroupPassword(String Source, CAENRFIDTag Tag, byte BlockGroupPtr, int NewPassword, int CurrentPassword) throws CAENRFIDException {
        byte subcmd = 10;
        short cmdlen = 10;
        short retpktlen = 0;
        byte[] data = new byte[cmdlen];
        data[0] = 0;
        data[1] = BlockGroupPtr;
        data[2] = (byte)((NewPassword & 0xFF000000) >> 24);
        data[3] = (byte)((NewPassword & 0xFF0000) >> 16);
        data[4] = (byte)((NewPassword & 0xFF00) >> 8);
        data[5] = (byte)(NewPassword & 0xFF);
        data[6] = (byte)((CurrentPassword & 0xFF000000) >> 24);
        data[7] = (byte)((CurrentPassword & 0xFF0000) >> 16);
        data[8] = (byte)((CurrentPassword & 0xFF00) >> 8);
        data[9] = (byte)(CurrentPassword & 0xFF);
        try {
            byte[] TRData = this.CustomCMD_EPC_C1G2(Source, Tag, subcmd, cmdlen, data, retpktlen);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    protected void Fujitsu_ChgBlockGroupPassword(String Source, CAENRFIDTag Tag, byte BlockGroupPtr, int NewPassword, int CurrentPassword, int SecurePassword) throws CAENRFIDException {
        byte subcmd = 10;
        short cmdlen = 10;
        short retpktlen = 0;
        byte[] data = new byte[cmdlen];
        data[0] = 0;
        data[1] = BlockGroupPtr;
        data[2] = (byte)((NewPassword & 0xFF000000) >> 24);
        data[3] = (byte)((NewPassword & 0xFF0000) >> 16);
        data[4] = (byte)((NewPassword & 0xFF00) >> 8);
        data[5] = (byte)(NewPassword & 0xFF);
        data[6] = (byte)((CurrentPassword & 0xFF000000) >> 24);
        data[7] = (byte)((CurrentPassword & 0xFF0000) >> 16);
        data[8] = (byte)((CurrentPassword & 0xFF00) >> 8);
        data[9] = (byte)(CurrentPassword & 0xFF);
        try {
            byte[] TRData = this.CustomCMD_EPC_C1G2(Source, Tag, subcmd, cmdlen, data, retpktlen, SecurePassword);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    protected byte Fujitsu_BurstWrite(String Source, CAENRFIDTag Tag, byte MemBank, short address, byte nbyte, byte[] data) throws CAENRFIDException {
        byte subcmd = 11;
        short cmdlen = (short)(4 + nbyte);
        short retpktlen = 1;
        byte[] dat = new byte[cmdlen];
        dat[0] = MemBank;
        dat[1] = (byte)((address & 0xFF00) >> 8);
        dat[2] = (byte)(address & 0xFF);
        dat[3] = nbyte;
        System.arraycopy(data, 0, dat, 4, nbyte);
        try {
            byte[] TRData = this.CustomCMD_EPC_C1G2(Source, Tag, subcmd, cmdlen, dat, retpktlen);
            return TRData[0];
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    protected byte Fujitsu_BurstWrite(String Source, CAENRFIDTag Tag, byte MemBank, short address, byte nbyte, byte[] data, int SecurePassword) throws CAENRFIDException {
        byte subcmd = 11;
        short cmdlen = (short)(4 + nbyte);
        short retpktlen = 1;
        byte[] dat = new byte[cmdlen];
        dat[0] = MemBank;
        dat[1] = (byte)((address & 0xFF00) >> 8);
        dat[2] = (byte)(address & 0xFF);
        dat[3] = nbyte;
        System.arraycopy(data, 0, dat, 4, nbyte);
        try {
            byte[] TRData = this.CustomCMD_EPC_C1G2(Source, Tag, subcmd, cmdlen, dat, retpktlen, SecurePassword);
            return TRData[0];
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    protected byte Fujitsu_BurstErase(String Source, CAENRFIDTag Tag, byte MemBank, short address, byte nbyte) throws CAENRFIDException {
        byte subcmd = 12;
        short cmdlen = 4;
        short retpktlen = 2;
        byte[] dat = new byte[cmdlen];
        dat[0] = MemBank;
        dat[1] = (byte)((address & 0xFF00) >> 8);
        dat[2] = (byte)(address & 0xFF);
        dat[3] = nbyte;
        try {
            byte[] TRData = this.CustomCMD_EPC_C1G2(Source, Tag, subcmd, cmdlen, dat, retpktlen);
            return TRData[0];
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    protected byte Fujitsu_BurstErase(String Source, CAENRFIDTag Tag, byte MemBank, short address, byte nbyte, int SecurePassword) throws CAENRFIDException {
        byte subcmd = 12;
        short cmdlen = 4;
        short retpktlen = 2;
        byte[] dat = new byte[cmdlen];
        dat[0] = MemBank;
        dat[1] = (byte)((address & 0xFF00) >> 8);
        dat[2] = (byte)(address & 0xFF);
        dat[3] = nbyte;
        try {
            byte[] TRData = this.CustomCMD_EPC_C1G2(Source, Tag, subcmd, cmdlen, dat, retpktlen, SecurePassword);
            return TRData[0];
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public CAENRFIDRFRegulations GetRFRegulation() throws CAENRFIDException {
        String err;
        short RFRegulation;
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)162));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)162);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            RFRegulation = InPacket.getShortAVP((short)119);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return new CAENRFIDRFRegulations(RFRegulation);
        }
        throw new CAENRFIDException(err);
    }

    public void SetRFRegulation(CAENRFIDRFRegulations RFRegulation) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)161));
        size = (short)(size + OutPacket.AddShortAVP((short)119, RFRegulation.getshortValue()));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)161);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    public short GetRFChannel() throws CAENRFIDException {
        String err;
        short RFChannel;
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)164));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)164);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            RFChannel = InPacket.getShortAVP((short)120);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return RFChannel;
        }
        throw new CAENRFIDException(err);
    }

    public void SetRFChannel(short Channel2) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)163));
        size = (short)(size + OutPacket.AddShortAVP((short)120, Channel2));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)163);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    public short GetLBTMode() throws CAENRFIDException {
        String err;
        short LBTMode;
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)160));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)160);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            LBTMode = InPacket.getShortAVP((short)87);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return LBTMode;
        }
        throw new CAENRFIDException(err);
    }

    public void SetLBTMode(short LBTMode) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)159));
        size = (short)(size + OutPacket.AddShortAVP((short)87, LBTMode));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)159);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected void ResetSession(String Source) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)165));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)165);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    public CAENRFIDNotify[] GetChannelData(CAENRFIDChannel Channel2) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        CAENRFIDNotify[] TagDetected = null;
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)167));
        size = (short)(size + OutPacket.AddStringAVP((short)30, Channel2.GetName()));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)167);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            ArrayList tags = InPacket.getReportBufferAVP();
            int n = tags.size();
            if (n > 0) {
                TagDetected = new CAENRFIDNotify[n];
                for (int i = 0; i < n; ++i) {
                    TagDetected[i] = (CAENRFIDNotify)tags.remove(0);
                }
            }
            return TagDetected;
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    public void _SetRFOnOff(short OnOff) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)128));
        size = (short)(size + OutPacket.AddShortAVP((short)95, OnOff));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)128);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected short GetChannelStatus(String Channel2) throws CAENRFIDException {
        String err;
        short param;
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)169));
        size = (short)(size + OutPacket.AddStringAVP((short)30, Channel2));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)169);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            param = InPacket.getShortAVP((short)87);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return param;
        }
        throw new CAENRFIDException(err);
    }

    public int GetIODirection() throws CAENRFIDException {
        String err;
        int IODIR;
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)137));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)137);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            IODIR = InPacket.getIntAVP((short)105);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return IODIR;
        }
        throw new CAENRFIDException(err);
    }

    public void SetIODIRECTION(int IODirection) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)136));
        size = (short)(size + OutPacket.AddIntAVP((short)105, IODirection));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)136);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    public void SetRS232(int baud, int datab, int stopb, CAENRFIDRS232Constants parity, CAENRFIDRS232Constants flowc) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)131));
        size = (short)(size + OutPacket.AddIntAVP((short)96, baud));
        size = (short)(size + OutPacket.AddIntAVP((short)97, datab));
        size = (short)(size + OutPacket.AddIntAVP((short)98, stopb));
        size = (short)(size + OutPacket.AddIntAVP((short)99, parity.getIntValue()));
        size = (short)(size + OutPacket.AddIntAVP((short)100, flowc.getIntValue()));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)131);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected CAENRFIDTag GroupSelUnsel(String Source, CAENRFIDSelUnselOptions code, short Address, short BitMask, byte[] Data) throws CAENRFIDException {
        String err;
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        CAENRFIDTag TagDetected = null;
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)133));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)102, code.getShortValue()));
        size = (short)(size + OutPacket.AddShortAVP((short)78, Address));
        size = (short)(size + OutPacket.AddShortAVP((short)103, BitMask));
        size = (short)(size + OutPacket.AddDataAVP((short)77, Data));
        OutPacket.SetPacketLength(size);
        boolean Result = this.Buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this.Buffer.GetPacket(headerID, (short)133);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            byte[] TagID = InPacket.getDataAVP((short)17, 8);
            TagDetected = new CAENRFIDTag(TagID, CAENRFIDProtocol.CAENRFID_ISO18000_6b, 8, this.GetSource(Source), "");
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return TagDetected;
        }
        throw new CAENRFIDException(err);
    }

    protected synchronized boolean getLoopStatus() {
        return this.Loop;
    }

    protected synchronized void setLoopStatus(boolean v) {
        this.Loop = v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean getAbortStatus() {
        Object object = this.AbortMutex;
        synchronized (object) {
            return this.Abort;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void setAbortStatus(boolean v) {
        Object object = this.AbortMutex;
        synchronized (object) {
            this.Abort = v;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class InventoryListener
    implements Runnable {
        private boolean ThereIsRSSI;
        private boolean IsCompact;
        private boolean IsFramed;
        private boolean ThereIsTID;
        private boolean ThereIsXPC;
        private CAENRFIDReader TheReader;
        private CAENRFIDLogicalSource TheSource;
        private short id;

        public InventoryListener(CAENRFIDReader Reader, CAENRFIDLogicalSource Source, short headerID, boolean framed, boolean rssi, boolean tid, boolean compact, boolean xpc) {
            this.TheReader = Reader;
            this.id = headerID;
            this.TheSource = Source;
            this.ThereIsRSSI = rssi;
            this.ThereIsTID = tid;
            this.ThereIsXPC = xpc;
            this.IsCompact = compact;
            this.IsFramed = framed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object TagDate = null;
            boolean loop = true;
            boolean ResultCode = false;
            ArrayList<CAENRFIDNotify> NData = new ArrayList<CAENRFIDNotify>();
            while (loop) {
                CAENRFIDNotify Notify;
                CAENRFIDTag TheTag;
                if (this.IsFramed) {
                    FramedInfo Finfo;
                    try {
                        Finfo = CAENRFIDReader.this.Buffer.getFramedTag(this.TheSource, this.ThereIsRSSI, this.ThereIsTID, this.IsCompact, this.ThereIsXPC);
                        TheTag = Finfo.getTag();
                    }
                    catch (Exception excpt) {
                        continue;
                    }
                    if (Finfo.getResult()) {
                        loop = false;
                    }
                    if (TheTag == null) continue;
                    try {
                        Notify = new CAENRFIDNotify(TheTag.GetId(), this.TheSource.GetName(), TheTag.GetLength(), CAENRFIDProtocol.CAENRFID_EPC_C1G2, CAENRFIDTagEventType.TAG_GLIMPSED, Calendar.getInstance().getTime(), TheTag.GetRSSI(), TheTag.GetTID(), TheTag.GetReadPoint());
                        NData.add(Notify);
                    }
                    catch (CAENRFIDException e) {}
                } else {
                    CAENRFIDInPacket InPacket = CAENRFIDReader.this.Buffer.GetPacket(this.id, (short)19);
                    if (InPacket == null) continue;
                    try {
                        ArrayList tags;
                        int n;
                        NotFramedInfo NFinfo = InPacket.getNotFramedTags(this.TheSource, this.ThereIsRSSI, this.ThereIsTID);
                        if (NFinfo.getResult()) {
                            loop = false;
                        }
                        if ((n = (tags = NFinfo.getTags()).size()) > 0) {
                            for (int i = 0; i < n; ++i) {
                                TheTag = (CAENRFIDTag)tags.remove(0);
                                try {
                                    Notify = new CAENRFIDNotify(TheTag.GetId(), this.TheSource.GetName(), TheTag.GetLength(), CAENRFIDProtocol.CAENRFID_EPC_C1G2, CAENRFIDTagEventType.TAG_GLIMPSED, Calendar.getInstance().getTime(), TheTag.GetRSSI(), TheTag.GetTID(), TheTag.GetReadPoint());
                                    NData.add(Notify);
                                    continue;
                                }
                                catch (CAENRFIDException e) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    catch (CAENRFIDException e1) {
                        // empty catch block
                    }
                }
                CAENRFIDEvent evt = NData.size() == 0 ? null : new CAENRFIDEvent(NData);
                this.TheReader.fireCAENRFIDEvent(evt);
                NData.clear();
            }
            Object object = CAENRFIDReader.this.InventoryMutex;
            synchronized (object) {
                this.TheReader.InventoryInProgress = false;
            }
        }
    }

    private class NotFramedInfo {
        private ArrayList TagsArray;
        private boolean rescod;

        public NotFramedInfo(ArrayList tags, boolean res) {
            this.TagsArray = tags;
            this.rescod = res;
        }

        public ArrayList getTags() {
            return this.TagsArray;
        }

        public boolean getResult() {
            return this.rescod;
        }
    }

    private class FramedInfo {
        private CAENRFIDTag Tag;
        private boolean rescod;

        public FramedInfo(CAENRFIDTag tag, boolean res) {
            this.Tag = tag;
            this.rescod = res;
        }

        public CAENRFIDTag getTag() {
            return this.Tag;
        }

        public boolean getResult() {
            return this.rescod;
        }
    }

    private class CAENRFIDOutPacket {
        private ByteBuffer OBuffer;
        private byte[] OutArray;
        private short ProgressID = 0;
        private int SizeOfAVP = 0;

        public short AddHeader() {
            short id = CAENRFIDReader.this.Buffer.getProgressID();
            short TxVer = -32767;
            int VendorID = 21336;
            boolean a = true;
            this.OBuffer = ByteBuffer.allocate(18);
            this.ProgressID = (short)(this.ProgressID + 1);
            this.OBuffer.putShort(TxVer);
            this.OBuffer.putShort(id);
            this.OBuffer.putInt(VendorID);
            this.OBuffer.position(10);
            return id;
        }

        public void addAbort() {
            this.OBuffer = ByteBuffer.allocate(1);
            this.OBuffer.put((byte)-85);
        }

        public short AddCommand(short c) {
            this.OBuffer.putShort((short)0);
            this.OBuffer.putShort((short)8);
            this.OBuffer.putShort((short)1);
            this.OBuffer.putShort(c);
            return 8;
        }

        private short AddShortAVP(short AVPType, short value) {
            int size = this.OBuffer.capacity();
            byte[] b2a = this.OBuffer.array();
            byte[] tmp = new byte[size + 8];
            System.arraycopy(b2a, 0, tmp, 0, b2a.length);
            this.OBuffer = ByteBuffer.wrap(tmp);
            this.OBuffer.position(size);
            this.OBuffer.putShort((short)0);
            this.OBuffer.putShort((short)8);
            this.OBuffer.putShort(AVPType);
            this.OBuffer.putShort(value);
            return 8;
        }

        private short AddIntAVP(short AVPType, int value) {
            int size = this.OBuffer.capacity();
            byte[] b2a = this.OBuffer.array();
            byte[] tmp = new byte[size + 10];
            System.arraycopy(b2a, 0, tmp, 0, b2a.length);
            this.OBuffer = ByteBuffer.wrap(tmp);
            this.OBuffer.position(size);
            this.OBuffer.putShort((short)0);
            this.OBuffer.putShort((short)10);
            this.OBuffer.putShort(AVPType);
            this.OBuffer.putInt(value);
            return 10;
        }

        private short AddStringAVP(short AVPType, String value) {
            int size = this.OBuffer.capacity();
            byte[] b2a = this.OBuffer.array();
            byte[] tmp = new byte[size + value.length() + 1 + 6];
            System.arraycopy(b2a, 0, tmp, 0, b2a.length);
            this.OBuffer = ByteBuffer.wrap(tmp);
            this.OBuffer.position(size);
            this.OBuffer.putShort((short)0);
            this.OBuffer.putShort((short)(value.length() + 1 + 6));
            this.OBuffer.putShort(AVPType);
            byte[] StrB = value.getBytes();
            this.OBuffer.put(StrB);
            this.OBuffer.put((byte)0);
            return (short)(value.length() + 1 + 6);
        }

        private short AddDataAVP(short AVPType, byte[] value) {
            int size = this.OBuffer.capacity();
            byte[] b2a = this.OBuffer.array();
            byte[] tmp = new byte[size + value.length + 6];
            System.arraycopy(b2a, 0, tmp, 0, b2a.length);
            this.OBuffer = ByteBuffer.wrap(tmp);
            this.OBuffer.position(size);
            this.OBuffer.putShort((short)0);
            this.OBuffer.putShort((short)(value.length + 6));
            this.OBuffer.putShort(AVPType);
            this.OBuffer.put(value);
            return (short)(value.length + 6);
        }

        private void SetPacketLength(short l) {
            this.OBuffer.position(8);
            this.OBuffer.putShort(l);
        }

        private short GetProgressID() {
            if (this.OBuffer.position() < 10) {
                return -1;
            }
            int pos = this.OBuffer.position();
            this.OBuffer.position(2);
            short id = this.OBuffer.getShort();
            this.OBuffer.position(pos);
            return id;
        }
    }

    private class CAENRFIDInPacket {
        private ByteBuffer IBuffer;
        private byte[] InArray;

        public CAENRFIDInPacket(byte[] InputArray) {
            this.IBuffer = ByteBuffer.wrap(InputArray);
        }

        private void position(int p) {
            this.IBuffer.position(p);
        }

        private int position() {
            return this.IBuffer.position();
        }

        private int capacity() {
            return this.IBuffer.capacity();
        }

        private boolean CheckHeader(short Id) {
            short lId;
            short TxVer;
            int pos = this.IBuffer.position();
            if (this.IBuffer.capacity() - pos < 10) {
                return false;
            }
            try {
                TxVer = this.IBuffer.getShort();
                lId = this.IBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                this.IBuffer.position(pos);
                return false;
            }
            int VendorID = this.IBuffer.getInt();
            if (TxVer != 1 || lId != Id || VendorID != 21336) {
                this.IBuffer.position(pos);
                return false;
            }
            try {
                short PacketLength = this.IBuffer.getShort();
                return true;
            }
            catch (BufferUnderflowException error) {
                this.IBuffer.position(pos);
                return false;
            }
        }

        private boolean CheckCommand(short Command) {
            short Result;
            short currentType;
            short currentSize;
            int pos = 0;
            pos = this.IBuffer.position();
            try {
                this.IBuffer.position(pos + 2);
            }
            catch (IllegalArgumentException err) {
                return false;
            }
            try {
                currentSize = this.IBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                return false;
            }
            currentSize = (short)(currentSize - 6);
            if (currentSize != 2) {
                return false;
            }
            try {
                currentType = this.IBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                return false;
            }
            if (currentType != 1) {
                return false;
            }
            try {
                Result = this.IBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                return false;
            }
            return Result == Command;
        }

        private short getShortAVP(short AVPType) throws CAENRFIDException {
            short Result;
            short currentType;
            short currentSize;
            int pos = this.IBuffer.position();
            try {
                this.IBuffer.position(pos + 2);
            }
            catch (IllegalArgumentException err) {
                throw new CAENRFIDException("@ AVP_ERROR");
            }
            try {
                currentSize = this.IBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                throw new CAENRFIDException("@ AVP_ERROR");
            }
            currentSize = (short)(currentSize - 6);
            if (currentSize != 2) {
                this.IBuffer.position(pos);
                throw new CAENRFIDException(this.getAVPStatus());
            }
            try {
                currentType = this.IBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                throw new CAENRFIDException("@ AVP_ERROR");
            }
            if (currentType != AVPType) {
                this.IBuffer.position(pos);
                throw new CAENRFIDException(this.getAVPStatus());
            }
            try {
                Result = this.IBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                throw new CAENRFIDException("@ AVP_ERROR");
            }
            return Result;
        }

        private int getIntAVP(short AVPType) throws CAENRFIDException {
            int Result;
            short currentType;
            short currentSize;
            int pos = this.IBuffer.position();
            try {
                this.IBuffer.position(pos + 2);
            }
            catch (IllegalArgumentException err) {
                throw new CAENRFIDException("@ AVP_ERROR");
            }
            try {
                currentSize = this.IBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                throw new CAENRFIDException("@ AVP_ERROR");
            }
            currentSize = (short)(currentSize - 6);
            if (currentSize != 4) {
                this.IBuffer.position(pos);
                throw new CAENRFIDException(this.getAVPStatus());
            }
            try {
                currentType = this.IBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                throw new CAENRFIDException("@ AVP_ERROR");
            }
            if (currentType != AVPType) {
                this.IBuffer.position(pos);
                throw new CAENRFIDException(this.getAVPStatus());
            }
            try {
                Result = this.IBuffer.getInt();
            }
            catch (BufferUnderflowException error) {
                this.IBuffer.position(pos);
                throw new CAENRFIDException(this.getAVPStatus());
            }
            return Result;
        }

        private int getDateAVP(short AVPType) throws CAENRFIDException {
            int Result;
            short currentType;
            short currentSize;
            int pos = this.IBuffer.position();
            try {
                this.IBuffer.position(pos + 2);
            }
            catch (IllegalArgumentException err) {
                throw new CAENRFIDException("@ AVP_ERROR");
            }
            try {
                currentSize = this.IBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                throw new CAENRFIDException("@ AVP_ERROR");
            }
            currentSize = (short)(currentSize - 6);
            if (currentSize != 8) {
                this.IBuffer.position(pos);
                throw new CAENRFIDException(this.getAVPStatus());
            }
            try {
                currentType = this.IBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                throw new CAENRFIDException("@ AVP_ERROR");
            }
            if (currentType != AVPType) {
                this.IBuffer.position(pos);
                throw new CAENRFIDException(this.getAVPStatus());
            }
            try {
                Result = this.IBuffer.getInt();
                int Result2 = this.IBuffer.getInt();
            }
            catch (BufferUnderflowException error) {
                this.IBuffer.position(pos);
                throw new CAENRFIDException(this.getAVPStatus());
            }
            return Result;
        }

        private long getLongAVP(short AVPType) throws CAENRFIDException {
            long Result;
            short currentType;
            short currentSize;
            int pos = this.IBuffer.position();
            try {
                this.IBuffer.position(pos + 2);
            }
            catch (IllegalArgumentException err) {
                throw new CAENRFIDException("@ AVP_ERROR");
            }
            try {
                currentSize = this.IBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                throw new CAENRFIDException("@ AVP_ERROR");
            }
            currentSize = (short)(currentSize - 6);
            if (currentSize != 8) {
                this.IBuffer.position(pos);
                throw new CAENRFIDException(this.getAVPStatus());
            }
            try {
                currentType = this.IBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                throw new CAENRFIDException("@ AVP_ERROR");
            }
            if (currentType != AVPType) {
                this.IBuffer.position(pos);
                throw new CAENRFIDException(this.getAVPStatus());
            }
            try {
                Result = this.IBuffer.getLong();
            }
            catch (BufferUnderflowException error) {
                this.IBuffer.position(pos);
                throw new CAENRFIDException(this.getAVPStatus());
            }
            return Result;
        }

        private String getStringAVP(short AVPType, int AVPSize) throws CAENRFIDException {
            byte[] tmp;
            short currentType;
            short currentSize;
            int pos = this.IBuffer.position();
            try {
                this.IBuffer.position(pos + 2);
            }
            catch (IllegalArgumentException err) {
                throw new CAENRFIDException("@ AVP_ERROR");
            }
            try {
                currentSize = this.IBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                throw new CAENRFIDException("@ AVP_ERROR");
            }
            currentSize = (short)(currentSize - 6);
            try {
                currentType = this.IBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                throw new CAENRFIDException("@ AVP_ERROR");
            }
            if (currentType != AVPType) {
                this.IBuffer.position(pos);
                throw new CAENRFIDException(this.getAVPStatus());
            }
            if (currentSize > AVPSize) {
                this.IBuffer.position(pos);
                throw new CAENRFIDException(this.getAVPStatus());
            }
            try {
                tmp = new byte[currentSize - 1];
                this.IBuffer.get(tmp, 0, currentSize - 1);
            }
            catch (BufferUnderflowException error) {
                this.IBuffer.position(pos);
                throw new CAENRFIDException(this.getAVPStatus());
            }
            String Result = new String(tmp);
            try {
                this.IBuffer.get(tmp, 0, 1);
            }
            catch (BufferUnderflowException error) {
                // empty catch block
            }
            return Result;
        }

        private byte[] getDataAVP(short AVPType, int AVPSize) throws CAENRFIDException {
            byte[] Result;
            short currentType;
            short currentSize;
            int pos = this.IBuffer.position();
            try {
                this.IBuffer.position(pos + 2);
            }
            catch (IllegalArgumentException err) {
                throw new CAENRFIDException("@ AVP_ERROR");
            }
            try {
                currentSize = this.IBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                throw new CAENRFIDException("@ AVP_ERROR");
            }
            currentSize = (short)(currentSize - 6);
            try {
                currentType = this.IBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                throw new CAENRFIDException("@ AVP_ERROR");
            }
            if (currentType != AVPType) {
                this.IBuffer.position(pos);
                throw new CAENRFIDException(this.getAVPStatus());
            }
            if (AVPType != 17 && currentSize > AVPSize) {
                this.IBuffer.position(pos);
                throw new CAENRFIDException(this.getAVPStatus());
            }
            try {
                Result = new byte[currentSize];
                this.IBuffer.get(Result, 0, currentSize);
            }
            catch (BufferUnderflowException error) {
                this.IBuffer.position(pos);
                throw new CAENRFIDException(this.getAVPStatus());
            }
            return Result;
        }

        protected byte[] getDataAVPCompact(short AVPType) throws CAENRFIDException {
            short currentType;
            short currentSize;
            byte[] Result = null;
            int pos = this.IBuffer.position();
            try {
                this.IBuffer.position(pos + 2);
            }
            catch (IllegalArgumentException err) {
                throw new CAENRFIDException("@ AVP_ERROR");
            }
            try {
                currentSize = this.IBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                throw new CAENRFIDException("@ AVP_ERROR");
            }
            currentSize = (short)(currentSize - 6);
            try {
                currentType = this.IBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                throw new CAENRFIDException("@ AVP_ERROR");
            }
            if (currentType != AVPType) {
                this.IBuffer.position(pos);
                throw new CAENRFIDException(this.getAVPStatus());
            }
            try {
                Result = new byte[currentSize];
                this.IBuffer.get(Result, 0, currentSize);
            }
            catch (BufferUnderflowException error) {
                this.IBuffer.position(pos);
                throw new CAENRFIDException(this.getAVPStatus());
            }
            return Result;
        }

        private ArrayList getTagsAVP(CAENRFIDLogicalSource LSource) throws CAENRFIDException {
            int pos = 0;
            int status = 0;
            String err = "@ Communication Error";
            String Antenna = "";
            Date TagDate = null;
            int length = 12;
            ArrayList<CAENRFIDTag> Tags = new ArrayList<CAENRFIDTag>();
            while (this.IBuffer.position() < this.IBuffer.capacity()) {
                switch (status) {
                    case 0: {
                        try {
                            pos = this.IBuffer.position();
                            String Source = this.getStringAVP((short)251, 30);
                            if (!Source.equals(LSource.GetName())) {
                                throw new CAENRFIDException("@ Communication Error");
                            }
                            status = 1;
                        }
                        catch (CAENRFIDException error) {
                            this.IBuffer.position(pos);
                            status = 5;
                        }
                        break;
                    }
                    case 1: {
                        try {
                            Antenna = this.getStringAVP((short)34, 5);
                            status = 2;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 2: {
                        try {
                            TagDate = new Date(this.getDateAVP((short)16) * 1000);
                            status = 3;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 3: {
                        try {
                            length = this.getShortAVP((short)15);
                            status = 4;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 4: {
                        try {
                            pos = this.IBuffer.position();
                            byte[] ID = this.getDataAVP((short)17, length);
                            CAENRFIDTag Tag = new CAENRFIDTag(ID, (short)ID.length, LSource, Antenna);
                            Tags.add(Tag);
                        }
                        catch (CAENRFIDException error) {
                            this.IBuffer.position(pos);
                            status = 0;
                        }
                        break;
                    }
                    case 5: {
                        err = this.getAVPStatus();
                        this.IBuffer.position(this.IBuffer.capacity());
                    }
                }
            }
            if (err.equals("Status_OK")) {
                return Tags;
            }
            throw new CAENRFIDException(err);
        }

        private ArrayList getIDsAVP(CAENRFIDLogicalSource LSource) throws CAENRFIDException {
            int pos = 0;
            int status = 0;
            String err = "@ Communication Error";
            String Antenna = "";
            Date TagDate = null;
            int length = 12;
            CAENRFIDProtocol proto = CAENRFIDProtocol.CAENRFID_MULTYPROTOCOL;
            ArrayList<CAENRFIDTag> Tags = new ArrayList<CAENRFIDTag>();
            while (this.IBuffer.position() < this.IBuffer.capacity()) {
                switch (status) {
                    case 0: {
                        try {
                            pos = this.IBuffer.position();
                            String Source = this.getStringAVP((short)251, 30);
                            if (!Source.equals(LSource.GetName())) {
                                throw new CAENRFIDException("@ Communication Error");
                            }
                            status = 1;
                        }
                        catch (CAENRFIDException error) {
                            this.IBuffer.position(pos);
                            status = 6;
                        }
                        break;
                    }
                    case 1: {
                        try {
                            Antenna = this.getStringAVP((short)34, 5);
                            status = 2;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 2: {
                        try {
                            TagDate = new Date(this.getDateAVP((short)16) * 1000);
                            status = 3;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 4: {
                        try {
                            length = this.getShortAVP((short)15);
                            status = 5;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 3: {
                        try {
                            short TagType = this.getShortAVP((short)18);
                            switch (TagType) {
                                case 0: {
                                    proto = CAENRFIDProtocol.CAENRFID_ISO18000_6b;
                                    break;
                                }
                                case 1: {
                                    proto = CAENRFIDProtocol.CAENRFID_EPC_C1G1;
                                    break;
                                }
                                case 2: {
                                    proto = CAENRFIDProtocol.CAENRFID_ISO18000_6a;
                                    break;
                                }
                                case 3: {
                                    proto = CAENRFIDProtocol.CAENRFID_EPC_C1G2;
                                    break;
                                }
                                case 4: {
                                    proto = CAENRFIDProtocol.CAENRFID_MULTYPROTOCOL;
                                    break;
                                }
                                case 5: {
                                    proto = CAENRFIDProtocol.CAENRFID_EPC119;
                                }
                            }
                            status = 4;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 5: {
                        try {
                            pos = this.IBuffer.position();
                            byte[] ID = this.getDataAVP((short)17, length);
                            CAENRFIDTag Tag = new CAENRFIDTag(ID, proto, (short)ID.length, LSource, Antenna, TagDate);
                            Tags.add(Tag);
                            status = 0;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 6: {
                        err = this.getAVPStatus();
                        this.IBuffer.position(this.IBuffer.capacity());
                    }
                }
            }
            if (err.equals("Status_OK")) {
                return Tags;
            }
            throw new CAENRFIDException(err);
        }

        private ArrayList getIDsAVPNew(CAENRFIDLogicalSource LSource, boolean compact, boolean rssi, boolean TID, boolean XPC) throws CAENRFIDException {
            int pos = 0;
            int status = 0;
            String err = "@ Communication Error";
            String Antenna = "";
            int length = 12;
            int TIDlen = 4;
            short m_rssi = 0;
            CAENRFIDProtocol proto = CAENRFIDProtocol.CAENRFID_MULTYPROTOCOL;
            byte[] ID = new byte[]{0, 0};
            byte[] TIDa = new byte[]{0, 0};
            byte[] XPCa = new byte[]{0, 0, 0, 0};
            ArrayList<CAENRFIDTag> Tags = new ArrayList<CAENRFIDTag>();
            if (compact) {
                status = 7;
            }
            while (this.IBuffer.position() < this.IBuffer.capacity()) {
                switch (status) {
                    case 0: {
                        try {
                            pos = this.IBuffer.position();
                            String Source = this.getStringAVP((short)251, 30);
                            if (!Source.equals(LSource.GetName())) {
                                throw new CAENRFIDException("@ Communication Error");
                            }
                            status = 1;
                        }
                        catch (CAENRFIDException error) {
                            this.IBuffer.position(pos);
                            status = 6;
                        }
                        break;
                    }
                    case 1: {
                        try {
                            Antenna = this.getStringAVP((short)34, 5);
                            status = 2;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 2: {
                        try {
                            Date TagDate = new Date(this.getDateAVP((short)16) * 1000);
                            status = 3;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 4: {
                        try {
                            length = this.getShortAVP((short)15);
                            status = 5;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 3: {
                        try {
                            short TagType = this.getShortAVP((short)18);
                            switch (TagType) {
                                case 0: {
                                    proto = CAENRFIDProtocol.CAENRFID_ISO18000_6b;
                                    break;
                                }
                                case 1: {
                                    proto = CAENRFIDProtocol.CAENRFID_EPC_C1G1;
                                    break;
                                }
                                case 2: {
                                    proto = CAENRFIDProtocol.CAENRFID_ISO18000_6a;
                                    break;
                                }
                                case 3: {
                                    proto = CAENRFIDProtocol.CAENRFID_EPC_C1G2;
                                    break;
                                }
                                case 4: {
                                    proto = CAENRFIDProtocol.CAENRFID_MULTYPROTOCOL;
                                    break;
                                }
                                case 5: {
                                    proto = CAENRFIDProtocol.CAENRFID_EPC119;
                                }
                            }
                            status = 4;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 5: {
                        CAENRFIDTag Tag;
                        try {
                            pos = this.IBuffer.position();
                            ID = this.getDataAVP((short)17, length);
                            if (rssi) {
                                status = 8;
                                break;
                            }
                            if (TID) {
                                status = 9;
                                break;
                            }
                            if (XPC) {
                                status = 11;
                                break;
                            }
                            Tag = new CAENRFIDTag(ID, proto, (short)ID.length, LSource, Antenna);
                            Tags.add(Tag);
                            status = 0;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 6: {
                        err = this.getAVPStatus();
                        this.IBuffer.position(this.IBuffer.capacity());
                        break;
                    }
                    case 7: {
                        CAENRFIDTag Tag;
                        try {
                            proto = CAENRFIDProtocol.CAENRFID_EPC_C1G2;
                            Antenna = "Ant0";
                            pos = this.IBuffer.position();
                            ID = this.getDataAVPCompact((short)17);
                            if (rssi) {
                                status = 8;
                                break;
                            }
                            if (TID) {
                                status = 9;
                                break;
                            }
                            Tag = new CAENRFIDTag(ID, proto, (short)ID.length, LSource, Antenna);
                            Tags.add(Tag);
                            status = 7;
                        }
                        catch (CAENRFIDException error) {
                            this.IBuffer.position(pos);
                            status = 6;
                        }
                        break;
                    }
                    case 8: {
                        CAENRFIDTag Tag;
                        try {
                            m_rssi = this.getShortAVP((short)122);
                            if (TID) {
                                status = 9;
                                break;
                            }
                            Tag = new CAENRFIDTag(ID, proto, (short)ID.length, LSource, Antenna, m_rssi);
                            Tags.add(Tag);
                            if (compact) {
                                status = 7;
                                break;
                            }
                            status = 0;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 9: {
                        CAENRFIDTag Tag;
                        try {
                            TIDlen = this.getShortAVP((short)80);
                            if (TIDlen == 0) {
                                Tag = new CAENRFIDTag(ID, proto, (short)ID.length, LSource, Antenna, m_rssi, null);
                                Tags.add(Tag);
                                if (compact) {
                                    status = 7;
                                    break;
                                }
                                status = 0;
                                break;
                            }
                            status = 10;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 10: {
                        CAENRFIDTag Tag;
                        try {
                            TIDa = this.getDataAVP((short)77, TIDlen);
                            Tag = new CAENRFIDTag(ID, proto, (short)ID.length, LSource, Antenna, m_rssi, TIDa);
                            Tags.add(Tag);
                            if (compact) {
                                status = 7;
                                break;
                            }
                            status = 0;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                }
            }
            if (err.equals("Status_OK")) {
                return Tags;
            }
            throw new CAENRFIDException(err);
        }

        private ArrayList getReportBufferAVP() throws CAENRFIDException {
            int pos = 0;
            int EvtType = 0;
            Date TagDate = null;
            int status = 0;
            String Source = "";
            String err = "@ Communication Error";
            int length = 12;
            CAENRFIDProtocol proto = CAENRFIDProtocol.CAENRFID_MULTYPROTOCOL;
            short TagType = 0;
            CAENRFIDTagEventType EventType = CAENRFIDTagEventType.TAG_UNKNOWN;
            byte[] ID = null;
            ArrayList<CAENRFIDNotify> Tags = new ArrayList<CAENRFIDNotify>();
            while (this.IBuffer.position() < this.IBuffer.capacity()) {
                switch (status) {
                    case 0: {
                        try {
                            pos = this.IBuffer.position();
                            length = this.getShortAVP((short)15);
                            status = 1;
                        }
                        catch (CAENRFIDException error) {
                            this.IBuffer.position(pos);
                            status = 6;
                        }
                        break;
                    }
                    case 1: {
                        try {
                            TagType = this.getShortAVP((short)18);
                            switch (TagType) {
                                case 0: {
                                    proto = CAENRFIDProtocol.CAENRFID_ISO18000_6b;
                                    break;
                                }
                                case 1: {
                                    proto = CAENRFIDProtocol.CAENRFID_EPC_C1G1;
                                    break;
                                }
                                case 2: {
                                    proto = CAENRFIDProtocol.CAENRFID_ISO18000_6a;
                                    break;
                                }
                                case 3: {
                                    proto = CAENRFIDProtocol.CAENRFID_EPC_C1G2;
                                    break;
                                }
                                case 4: {
                                    proto = CAENRFIDProtocol.CAENRFID_MULTYPROTOCOL;
                                    break;
                                }
                                case 5: {
                                    proto = CAENRFIDProtocol.CAENRFID_EPC119;
                                }
                            }
                            status = 2;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 2: {
                        try {
                            pos = this.IBuffer.position();
                            ID = this.getDataAVP((short)17, length);
                            status = 3;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 3: {
                        try {
                            EvtType = this.getIntAVP((short)14);
                            switch (EvtType) {
                                case 1: {
                                    EventType = CAENRFIDTagEventType.TAG_GLIMPSED;
                                    break;
                                }
                                case 3: {
                                    EventType = CAENRFIDTagEventType.TAG_OBSERVED;
                                    break;
                                }
                                case 4: {
                                    EventType = CAENRFIDTagEventType.TAG_LOST;
                                }
                            }
                            status = 4;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 4: {
                        try {
                            Source = this.getStringAVP((short)251, 30);
                            status = 5;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 5: {
                        try {
                            TagDate = new Date(this.getDateAVP((short)16) * 1000);
                            if (ID != null && TagDate != null) {
                                CAENRFIDNotify nTag = new CAENRFIDNotify(ID, Source, (short)ID.length, proto, EventType, TagDate);
                                Tags.add(nTag);
                            }
                            status = 0;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 6: {
                        err = this.getAVPStatus();
                        this.IBuffer.position(this.IBuffer.capacity());
                    }
                }
            }
            if (err.equals("Status_OK")) {
                return Tags;
            }
            throw new CAENRFIDException(err);
        }

        private String getAVPStatus() {
            String Status;
            short currentType;
            short currentSize = 0;
            int pos = this.IBuffer.position();
            try {
                this.IBuffer.position(pos + 2);
            }
            catch (IllegalArgumentException err) {
                String Status2 = "@ AVP_ERROR";
                return Status2;
            }
            try {
                currentSize = this.IBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                String Status3 = "@ AVP_ERROR";
                return Status3;
            }
            currentSize = (short)(currentSize - 6);
            try {
                currentType = this.IBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                String Status4 = "@ AVP_ERROR";
                return Status4;
            }
            if (currentType != 2) {
                Status = "@ Internal Error!";
            } else {
                short status;
                try {
                    status = this.IBuffer.getShort();
                }
                catch (BufferUnderflowException error) {
                    String Status5 = "@ AVP_ERROR";
                    return Status5;
                }
                switch (status) {
                    case 0: {
                        Status = "Status_OK";
                        break;
                    }
                    case 100: {
                        Status = "@ Channel Name exist";
                        break;
                    }
                    case 101: {
                        Status = "@ Channel address already in use";
                        break;
                    }
                    case 102: {
                        Status = "@ Unknown Error";
                        break;
                    }
                    case 103: {
                        Status = "@ Bad Channel";
                        break;
                    }
                    case 104: {
                        Status = "@ Invalid Source Name";
                        break;
                    }
                    case 105: {
                        Status = "@ Invalid Channel Name";
                        break;
                    }
                    case 106: {
                        Status = "@ To many Channels";
                        break;
                    }
                    case 107: {
                        Status = "@ To many Sources";
                        break;
                    }
                    case 109: {
                        Status = "@ Source not in Channel";
                        break;
                    }
                    case 110: {
                        Status = "@ Bad timer value";
                        break;
                    }
                    case 111: {
                        Status = "@ Trigger name exist";
                        break;
                    }
                    case 112: {
                        Status = "@ To manu Triggers";
                        break;
                    }
                    case 113: {
                        Status = "@ Bad Trigger";
                        break;
                    }
                    case 114: {
                        Status = "@ Bad Address";
                        break;
                    }
                    case 115: {
                        Status = "@ Invalid Protocol";
                        break;
                    }
                    case 116: {
                        Status = "@ Bad Port Address";
                        break;
                    }
                    case 117: {
                        Status = "@ Can't connect to server";
                        break;
                    }
                    case 118: {
                        Status = "@ Invalid Trigger Name";
                        break;
                    }
                    case 119: {
                        Status = "@ Invalid Time";
                        break;
                    }
                    case 120: {
                        Status = "@ Source not found";
                        break;
                    }
                    case 121: {
                        Status = "@ Trigger not found";
                        break;
                    }
                    case 122: {
                        Status = "@ Channel not found";
                        break;
                    }
                    case 123: {
                        Status = "@ Bad ReadPoint";
                        break;
                    }
                    case 124: {
                        Status = "@ Channel busy";
                        break;
                    }
                    case 125: {
                        Status = "@ Trigger busy";
                        break;
                    }
                    case 126: {
                        Status = "@ Internal Filesystem error";
                        break;
                    }
                    case 127: {
                        Status = "@ Invalid Command";
                        break;
                    }
                    case 128: {
                        Status = "@ Bad Parameter's value";
                        break;
                    }
                    case 129: {
                        Status = "@ Notify Server not ready";
                        break;
                    }
                    case 183: {
                        Status = "@ Power value out of range";
                        break;
                    }
                    case 200: {
                        Status = "@ Invalid parameter";
                        break;
                    }
                    case 201: {
                        Status = "@ Logical Source disabled";
                        break;
                    }
                    case 202: {
                        Status = "@ Tag not present";
                        break;
                    }
                    case 203: {
                        Status = "@ Error writing in Tag";
                        break;
                    }
                    case 204: {
                        Status = "@ Tag Locked";
                        break;
                    }
                    case 205: {
                        Status = "@ Bad Tag's address";
                        break;
                    }
                    case 206: {
                        Status = "@ Invalid function";
                        break;
                    }
                    case 207: {
                        Status = "@ Select/Unselect error";
                        break;
                    }
                    case 209: {
                        Status = "@ Tag Locked";
                        break;
                    }
                    case 210: {
                        Status = "@ Unsupported";
                        break;
                    }
                    case 211: {
                        Status = "@ Power Error";
                        break;
                    }
                    case 212: {
                        Status = "@ Non Specific Error";
                        break;
                    }
                    case 213: {
                        Status = "@ Kill Tag Error";
                        break;
                    }
                    case 214: {
                        Status = "@ Channels Fulls";
                        break;
                    }
                    default: {
                        Status = "@ Generic Error";
                    }
                }
            }
            return Status;
        }

        protected NotFramedInfo getNotFramedTags(CAENRFIDLogicalSource LSource, boolean rssi, boolean tid) throws CAENRFIDException {
            int pos = 0;
            int status = 0;
            String err = "@ Communication Error";
            String Antenna = "";
            Date TagDate = null;
            int length = 12;
            short m_rssi = 0;
            short TIDlen = 0;
            CAENRFIDProtocol proto = CAENRFIDProtocol.CAENRFID_MULTYPROTOCOL;
            byte[] ID = new byte[]{0, 0};
            ArrayList<CAENRFIDTag> Tags = new ArrayList<CAENRFIDTag>();
            while (this.IBuffer.position() < this.IBuffer.capacity()) {
                switch (status) {
                    case 0: {
                        try {
                            pos = this.IBuffer.position();
                            String Source = this.getStringAVP((short)251, 30);
                            if (!Source.equals(LSource.GetName())) {
                                throw new CAENRFIDException("@ Communication Error");
                            }
                            status = 1;
                        }
                        catch (CAENRFIDException error) {
                            this.IBuffer.position(pos);
                            status = 6;
                        }
                        break;
                    }
                    case 1: {
                        try {
                            Antenna = this.getStringAVP((short)34, 5);
                            status = 2;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 2: {
                        try {
                            TagDate = new Date(this.getDateAVP((short)16) * 1000);
                            status = 3;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 4: {
                        try {
                            length = this.getShortAVP((short)15);
                            status = 5;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 3: {
                        try {
                            short TagType = this.getShortAVP((short)18);
                            switch (TagType) {
                                case 0: {
                                    proto = CAENRFIDProtocol.CAENRFID_ISO18000_6b;
                                    break;
                                }
                                case 1: {
                                    proto = CAENRFIDProtocol.CAENRFID_EPC_C1G1;
                                    break;
                                }
                                case 2: {
                                    proto = CAENRFIDProtocol.CAENRFID_ISO18000_6a;
                                    break;
                                }
                                case 3: {
                                    proto = CAENRFIDProtocol.CAENRFID_EPC_C1G2;
                                    break;
                                }
                                case 4: {
                                    proto = CAENRFIDProtocol.CAENRFID_MULTYPROTOCOL;
                                    break;
                                }
                                case 5: {
                                    proto = CAENRFIDProtocol.CAENRFID_EPC119;
                                }
                            }
                            status = 4;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 5: {
                        CAENRFIDTag Tag;
                        try {
                            pos = this.IBuffer.position();
                            ID = this.getDataAVP((short)17, length);
                            if (rssi) {
                                status = 7;
                                break;
                            }
                            if (tid) {
                                status = 9;
                                break;
                            }
                            Tag = new CAENRFIDTag(ID, proto, (short)ID.length, LSource, Antenna);
                            Tags.add(Tag);
                            status = 0;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 6: {
                        err = this.getAVPStatus();
                        this.IBuffer.position(this.IBuffer.capacity());
                        break;
                    }
                    case 7: {
                        CAENRFIDTag Tag;
                        try {
                            m_rssi = this.getShortAVP((short)122);
                            if (tid) {
                                status = 9;
                                break;
                            }
                            Tag = new CAENRFIDTag(ID, proto, (short)ID.length, LSource, Antenna, m_rssi);
                            Tags.add(Tag);
                            status = 0;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 9: {
                        CAENRFIDTag Tag;
                        try {
                            TIDlen = this.getShortAVP((short)80);
                            if (TIDlen == 0) {
                                Tag = new CAENRFIDTag(ID, proto, (short)ID.length, LSource, Antenna, m_rssi);
                                Tags.add(Tag);
                                status = 0;
                                break;
                            }
                            status = 10;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 10: {
                        CAENRFIDTag Tag;
                        try {
                            byte[] aTID = this.getDataAVP((short)77, TIDlen);
                            Tag = new CAENRFIDTag(ID, proto, (short)ID.length, LSource, Antenna, m_rssi, aTID, TagDate);
                            Tags.add(Tag);
                            status = 0;
                            break;
                        }
                        catch (CAENRFIDException err10) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                }
            }
            boolean rescod = err.equals("Status_OK");
            return new NotFramedInfo(Tags, rescod);
        }
    }

    private class IOBuffer
    implements SerialPortEventListener {
        private ByteBuffer OBuffer;
        private ByteBuffer IBuffer;
        private ByteBuffer QBuffer;
        private byte[] InArray;
        private byte[] global_rx_rowbuffer;
        private ByteBuffer tmp_ByteBuffer;
        private Hashtable PacketCache = new Hashtable();
        private short InventoryPID = 0;
        private short ProgressID = 0;
        private final Object SerialBufferMutex = new Object();
        private boolean SerialBufferEmpty = true;

        private synchronized short getProgressID() {
            short p = this.ProgressID;
            this.ProgressID = (short)(this.ProgressID + 1);
            return p;
        }

        private int NBRead(int size, int TOut) {
            int Result = 0;
            boolean loop = true;
            int a = 0;
            try {
                int start = this.IBuffer.position();
                byte[] tmp = this.IBuffer.array();
                if (CAENRFIDReader.this.ConnectionType == CAENRFIDPort.CAENRFID_TCP) {
                    CAENRFIDReader.this.TCPSocket.setSoTimeout(TOut);
                }
                int tmp_size = size;
                while (loop) {
                    a = CAENRFIDReader.this.TCPIn.read(tmp, start, tmp_size);
                    if (a == -1) {
                        return 0;
                    }
                    start += a;
                    if ((tmp_size -= a) == 0) {
                        this.IBuffer = ByteBuffer.wrap(tmp);
                        loop = false;
                        return 1;
                    }
                    if (a != 0) continue;
                    return -1;
                }
            }
            catch (IOException error) {
                return -1;
            }
            return Result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int SerialRead() {
            boolean size1 = false;
            boolean totalsize = false;
            boolean Result = false;
            int loop = 400000;
            boolean a = false;
            boolean DataReady = false;
            while (loop > 0 && !DataReady) {
                try {
                    Thread.sleep(100L);
                    --loop;
                    Object object = this.SerialBufferMutex;
                    synchronized (object) {
                        DataReady = !this.SerialBufferEmpty;
                    }
                }
                catch (InterruptedException e) {
                }
            }
            if (!DataReady) {
                return 0;
            }
            return 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serialEvent(SerialPortEvent event) {
            switch (event.getEventType()) {
                case 10: {
                    break;
                }
                case 7: {
                    break;
                }
                case 9: {
                    break;
                }
                case 8: {
                    break;
                }
                case 6: {
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    break;
                }
                case 2: {
                    break;
                }
                case 1: {
                    int start = 0;
                    boolean HaveToEnqueue = false;
                    Object object = this.SerialBufferMutex;
                    synchronized (object) {
                        try {
                            int numBytes;
                            int size;
                            if (this.global_rx_rowbuffer == null) {
                                HaveToEnqueue = false;
                                size = 0;
                            } else {
                                HaveToEnqueue = true;
                                size = this.global_rx_rowbuffer.length;
                            }
                            int rx_data_len = CAENRFIDReader.this.RS232In.available();
                            if (rx_data_len < 1) {
                                return;
                            }
                            byte[] tmp = new byte[size += rx_data_len];
                            if (HaveToEnqueue) {
                                System.arraycopy(this.global_rx_rowbuffer, 0, tmp, 0, this.global_rx_rowbuffer.length);
                                start = this.global_rx_rowbuffer.length;
                            }
                            if ((numBytes = CAENRFIDReader.this.RS232In.read(tmp, start, rx_data_len)) != rx_data_len) {
                                // empty if block
                            }
                            this.global_rx_rowbuffer = new byte[tmp.length];
                            System.arraycopy(tmp, 0, this.global_rx_rowbuffer, 0, tmp.length);
                            this.UpdateCache();
                        }
                        catch (Exception e) {
                            System.out.println(e.toString());
                        }
                    }
                    return;
                }
            }
        }

        private void UpdateCache() {
            byte[] tmp;
            int length = 0;
            short pid = 0;
            while (length + 6 < this.global_rx_rowbuffer.length) {
                int packetlen;
                if (this.global_rx_rowbuffer[length + 0] == 0 && this.global_rx_rowbuffer[length + 1] == 1 && this.global_rx_rowbuffer[length + 4] == 0 && this.global_rx_rowbuffer[length + 5] == 0) {
                    if (length + 10 < this.global_rx_rowbuffer.length) {
                        this.tmp_ByteBuffer = ByteBuffer.wrap(this.global_rx_rowbuffer);
                        this.tmp_ByteBuffer.position(length + 10 - 2);
                        packetlen = this.tmp_ByteBuffer.getShort();
                        if (packetlen == 0) {
                            packetlen = 18;
                        }
                        if (packetlen > this.global_rx_rowbuffer.length - length) {
                            if (length != 0) {
                                tmp = new byte[this.global_rx_rowbuffer.length - length];
                                System.arraycopy(this.global_rx_rowbuffer, length, tmp, 0, this.global_rx_rowbuffer.length - length);
                                this.global_rx_rowbuffer = new byte[tmp.length];
                                System.arraycopy(tmp, 0, this.global_rx_rowbuffer, 0, tmp.length);
                            }
                            return;
                        }
                        tmp = new byte[packetlen];
                        System.arraycopy(this.global_rx_rowbuffer, length, tmp, 0, packetlen);
                        this.tmp_ByteBuffer = ByteBuffer.wrap(tmp);
                        this.tmp_ByteBuffer.position(2);
                        pid = this.tmp_ByteBuffer.getShort();
                        this.tmp_ByteBuffer.rewind();
                        CAENQueue coda = new CAENQueue();
                        coda.enqueue(this.tmp_ByteBuffer);
                        this.PacketCache.put(new Short(pid), coda);
                        length += packetlen;
                        continue;
                    }
                    if (length != 0) {
                        tmp = new byte[this.global_rx_rowbuffer.length - length];
                        System.arraycopy(this.global_rx_rowbuffer, length, tmp, 0, this.global_rx_rowbuffer.length - length);
                        this.global_rx_rowbuffer = new byte[tmp.length];
                        System.arraycopy(tmp, 0, this.global_rx_rowbuffer, 0, tmp.length);
                    }
                    return;
                }
                this.tmp_ByteBuffer = ByteBuffer.wrap(this.global_rx_rowbuffer);
                this.tmp_ByteBuffer.position(length);
                short avpheader = this.tmp_ByteBuffer.getShort();
                packetlen = this.tmp_ByteBuffer.getShort();
                if (avpheader == 0 && packetlen != 0) {
                    CAENQueue coda;
                    if (packetlen > this.global_rx_rowbuffer.length - length) {
                        if (length != 0) {
                            tmp = new byte[this.global_rx_rowbuffer.length - length];
                            System.arraycopy(this.global_rx_rowbuffer, length, tmp, 0, this.global_rx_rowbuffer.length - length);
                            this.global_rx_rowbuffer = new byte[tmp.length];
                            System.arraycopy(tmp, 0, this.global_rx_rowbuffer, 0, tmp.length);
                        }
                        return;
                    }
                    tmp = new byte[packetlen];
                    System.arraycopy(this.global_rx_rowbuffer, length, tmp, 0, packetlen);
                    this.tmp_ByteBuffer = ByteBuffer.wrap(tmp);
                    short type = this.tmp_ByteBuffer.getShort();
                    type = this.tmp_ByteBuffer.getShort();
                    type = this.tmp_ByteBuffer.getShort();
                    this.tmp_ByteBuffer = ByteBuffer.wrap(tmp);
                    pid = this.InventoryPID;
                    boolean res = this.PacketCache.containsKey(new Short(pid));
                    if (!res) {
                        coda = new CAENQueue();
                        coda.enqueue(this.tmp_ByteBuffer);
                        this.PacketCache.put(new Short(pid), coda);
                    } else {
                        coda = (CAENQueue)this.PacketCache.get(new Short(pid));
                        coda.enqueue(this.tmp_ByteBuffer);
                        this.PacketCache.remove(new Short(pid));
                        this.PacketCache.put(new Short(pid), coda);
                    }
                    length += packetlen;
                    continue;
                }
                ++length;
            }
            if (length != 0) {
                tmp = new byte[this.global_rx_rowbuffer.length - length];
                System.arraycopy(this.global_rx_rowbuffer, length, tmp, 0, this.global_rx_rowbuffer.length - length);
                this.global_rx_rowbuffer = new byte[tmp.length];
                System.arraycopy(tmp, 0, this.global_rx_rowbuffer, 0, tmp.length);
            }
        }

        private void SetInventoryPID(short p) {
            this.InventoryPID = p;
        }

        private short getAVPPid() {
            return this.InventoryPID;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void clearGBuffer() {
            Object object = this.SerialBufferMutex;
            synchronized (object) {
                this.global_rx_rowbuffer = null;
            }
        }

        private synchronized boolean SendPacket(CAENRFIDOutPacket pack) {
            byte[] tmp = pack.OBuffer.array();
            this.OBuffer = ByteBuffer.wrap(tmp);
            if (CAENRFIDReader.this.ConnectionType == CAENRFIDPort.CAENRFID_TCP) {
                this.OBuffer.rewind();
                boolean Result = true;
                try {
                    CAENRFIDReader.this.TCPOut.flush();
                    CAENRFIDReader.this.TCPOut.write(this.OBuffer.array());
                    CAENRFIDReader.this.TCPOut.flush();
                }
                catch (IOException error) {
                    Result = false;
                }
                return Result;
            }
            if (CAENRFIDReader.this.ConnectionType == CAENRFIDPort.CAENRFID_RS232) {
                boolean Result = true;
                this.OBuffer.rewind();
                byte[] b = this.OBuffer.array();
                try {
                    if (this.OBuffer.capacity() != 1) {
                        CAENRFIDReader.this.RS232Out.flush();
                    }
                    CAENRFIDReader.this.RS232Out.write(b);
                    CAENRFIDReader.this.RS232Out.flush();
                }
                catch (IOException error) {
                    Result = false;
                }
                return Result;
            }
            return false;
        }

        private CAENRFIDInPacket GetPacket(short Id, short Command) {
            boolean i = false;
            int to = 4000000;
            CAENRFIDInPacket pack = null;
            boolean out = false;
            while (!out) {
                try {
                    pack = CAENRFIDReader.this.Buffer._GetPacket(Id, Command);
                    if (pack != null) {
                        out = true;
                        continue;
                    }
                    Thread.sleep(0L);
                }
                catch (IOException ioe) {
                    if (!ioe.getMessage().equals("TIMEOUT")) continue;
                    out = true;
                }
                catch (InterruptedException iee) {}
            }
            return pack;
        }

        private CAENRFIDInPacket GetPacket(short Id) {
            int i = 0;
            int to = 4000000;
            CAENRFIDInPacket pack = null;
            boolean out = false;
            while (!out && i < to) {
                try {
                    pack = CAENRFIDReader.this.Buffer._GetPacket(Id, (short)-1);
                    if (pack != null) {
                        out = true;
                        continue;
                    }
                    Thread.sleep(10L);
                    ++i;
                }
                catch (IOException ioe) {
                    if (!ioe.getMessage().equals("TIMEOUT")) continue;
                    out = true;
                }
                catch (InterruptedException iee) {}
            }
            return pack;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized CAENRFIDInPacket _GetPacket(short Id, short Command) throws IOException {
            CAENRFIDInPacket myBuffer;
            block26: {
                short size = 0;
                int status = 0;
                int size1 = 0;
                int totalsize = 0;
                boolean flag = false;
                boolean error = false;
                ByteBuffer buff = null;
                myBuffer = null;
                CAENQueue coda = null;
                short pid = Id;
                int lastpos = 0;
                try {
                    byte[] tmp;
                    if (CAENRFIDReader.this.ConnectionType == CAENRFIDPort.CAENRFID_RS232) {
                        Object object = this.SerialBufferMutex;
                        synchronized (object) {
                            boolean res = this.PacketCache.containsKey(new Short(pid));
                            if (res) {
                                coda = (CAENQueue)this.PacketCache.get(new Short(pid));
                                buff = coda.dequeue();
                                this.PacketCache.remove(new Short(pid));
                                if (!coda.isEmpty()) {
                                    this.PacketCache.put(new Short(pid), coda);
                                }
                                myBuffer = new CAENRFIDInPacket(buff.array());
                                if (Command != -1) {
                                    res = false;
                                    res = myBuffer.CheckHeader(pid);
                                    res = myBuffer.CheckCommand(Command);
                                    if (!res) {
                                        coda = new CAENQueue();
                                        coda.enqueue(buff);
                                        this.PacketCache.put(new Short(pid), coda);
                                    }
                                }
                            }
                        }
                    }
                    if (CAENRFIDReader.this.ConnectionType != CAENRFIDPort.CAENRFID_TCP) break block26;
                    if (this.QBuffer != null) {
                        this.QBuffer.position(0);
                        while (!flag && this.QBuffer.position() < this.QBuffer.capacity()) {
                            lastpos = this.QBuffer.position();
                            flag = this.CheckHeader(Id);
                            if (flag) {
                                flag = this.CheckCommand(Command);
                            }
                            if (flag) continue;
                            this.QBuffer.position(lastpos);
                            error = this.JumpPacket();
                            if (!error) continue;
                            this.QBuffer.position(this.QBuffer.capacity());
                        }
                        if (flag) {
                            this.QBuffer.position(this.QBuffer.position() - 10 - 8);
                            size = this.PacketLength();
                            this.InArray = this.QBuffer.array();
                            byte[] NewArray = new byte[this.QBuffer.capacity() - size];
                            byte[] ReadArray = new byte[size];
                            if (this.QBuffer.position() != 0) {
                                System.arraycopy(this.InArray, 0, NewArray, 0, this.QBuffer.position());
                                System.arraycopy(this.InArray, this.QBuffer.position() + size, NewArray, this.QBuffer.position(), this.QBuffer.capacity() - size - this.QBuffer.position());
                            } else {
                                System.arraycopy(this.InArray, size, NewArray, 0, this.QBuffer.capacity() - size);
                            }
                            System.arraycopy(this.InArray, this.QBuffer.position(), ReadArray, 0, size);
                            this.QBuffer = ByteBuffer.wrap(NewArray);
                            CAENRFIDInPacket InPacket = new CAENRFIDInPacket(ReadArray);
                            return InPacket;
                        }
                        this.QBuffer.position(this.QBuffer.capacity());
                    }
                    this.IBuffer = ByteBuffer.allocate(10);
                    this.InArray = new byte[10];
                    boolean Result = true;
                    status = this.NBRead(10, 40000000);
                    if (status < 1) {
                        throw new IOException("TIMEOUT");
                    }
                    this.InArray = this.IBuffer.array();
                    try {
                        this.IBuffer.position(8);
                        totalsize = this.IBuffer.getShort();
                        size1 = totalsize - 10;
                        tmp = new byte[totalsize];
                        System.arraycopy(this.InArray, 0, tmp, 0, this.InArray.length);
                        this.IBuffer = ByteBuffer.wrap(tmp);
                        this.IBuffer.position(10);
                        status = this.NBRead(size1, 40000000);
                    }
                    catch (BufferUnderflowException err) {
                        status = 0;
                    }
                    if (status < 1) {
                        throw new IOException("TIMEOUT");
                    }
                    this.IBuffer.rewind();
                    flag = false;
                    try {
                        flag = this.CheckHeaderInside(Id);
                        if (flag) {
                            flag = this.CheckCommandInside(Command);
                        }
                        if (flag) {
                            CAENRFIDInPacket InPacket = new CAENRFIDInPacket(this.IBuffer.array());
                            InPacket.IBuffer.position(18);
                            return InPacket;
                        }
                    }
                    catch (IOException e) {
                        return null;
                    }
                    totalsize = (this.QBuffer != null ? this.QBuffer.capacity() : 0) + this.IBuffer.capacity();
                    byte[] IArray = this.IBuffer.array();
                    tmp = new byte[totalsize];
                    if (this.QBuffer != null) {
                        this.InArray = this.QBuffer.array();
                        System.arraycopy(this.InArray, 0, tmp, 0, this.InArray.length);
                        System.arraycopy(IArray, 0, tmp, this.InArray.length, IArray.length);
                    } else {
                        System.arraycopy(IArray, 0, tmp, 0, IArray.length);
                    }
                    this.QBuffer = ByteBuffer.wrap(tmp);
                }
                catch (Exception e) {
                    return null;
                }
            }
            return myBuffer;
        }

        private boolean CheckHeaderInside(short Id) throws IOException {
            short lId;
            short TxVer;
            int pos = this.IBuffer.position();
            if (this.IBuffer.capacity() - pos < 10) {
                return false;
            }
            try {
                TxVer = this.IBuffer.getShort();
                lId = this.IBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                throw new IOException("BADPACKET");
            }
            int VendorID = this.IBuffer.getInt();
            if (TxVer != 1 || lId != Id || VendorID != 21336) {
                this.IBuffer.position(pos);
                return false;
            }
            try {
                short PacketLength = this.IBuffer.getShort();
                return true;
            }
            catch (BufferUnderflowException error) {
                this.IBuffer.position(pos);
                throw new IOException("BADPACKET");
            }
        }

        private boolean CheckCommandInside(short Command) throws IOException {
            short Result;
            short currentType;
            short currentSize;
            int pos = 0;
            pos = this.IBuffer.position();
            try {
                this.IBuffer.position(pos + 2);
            }
            catch (IllegalArgumentException err) {
                throw new IOException("BADPACKET");
            }
            try {
                currentSize = this.IBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                throw new IOException("BADPACKET");
            }
            currentSize = (short)(currentSize - 6);
            if (currentSize != 2) {
                throw new IOException("BADPACKET");
            }
            try {
                currentType = this.IBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                throw new IOException("BADPACKET");
            }
            if (currentType != 1) {
                throw new IOException("BADPACKET");
            }
            try {
                Result = this.IBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                throw new IOException("BADPACKET");
            }
            return Result == Command;
        }

        private boolean JumpPacket() {
            int pos = this.QBuffer.position();
            if (this.QBuffer.capacity() - pos < 10) {
                this.QBuffer.position(this.QBuffer.capacity());
                return false;
            }
            try {
                short TxVer = this.QBuffer.getShort();
                short lId = this.QBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                this.QBuffer.position(pos);
                return true;
            }
            int VendorID = this.QBuffer.getInt();
            try {
                short PacketLength = this.QBuffer.getShort();
                this.QBuffer.position(pos + PacketLength);
                return false;
            }
            catch (BufferUnderflowException error) {
                this.QBuffer.position(pos);
                return true;
            }
        }

        private short PacketLength() {
            int pos = this.QBuffer.position();
            if (this.QBuffer.capacity() - pos < 10) {
                this.QBuffer.position(this.QBuffer.capacity());
                return 0;
            }
            try {
                short TxVer = this.QBuffer.getShort();
                short lId = this.QBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                this.QBuffer.position(pos);
                return 0;
            }
            int VendorID = this.QBuffer.getInt();
            try {
                short PacketLength = this.QBuffer.getShort();
                this.QBuffer.position(pos);
                return PacketLength;
            }
            catch (BufferUnderflowException error) {
                this.QBuffer.position(pos);
                return 0;
            }
        }

        private boolean CheckHeader(short Id) {
            short lId;
            short TxVer;
            int pos = this.QBuffer.position();
            if (this.QBuffer.capacity() - pos < 10) {
                return false;
            }
            try {
                TxVer = this.QBuffer.getShort();
                lId = this.QBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                this.QBuffer.position(pos);
                return false;
            }
            int VendorID = this.QBuffer.getInt();
            if (TxVer != 1 || lId != Id || VendorID != 21336) {
                this.QBuffer.position(pos);
                return false;
            }
            try {
                short PacketLength = this.QBuffer.getShort();
                return true;
            }
            catch (BufferUnderflowException error) {
                this.QBuffer.position(pos);
                return false;
            }
        }

        private boolean CheckHeaderInside(ByteBuffer lBUffer, short Id) throws IOException {
            short lId;
            short TxVer;
            int pos = lBUffer.position();
            if (lBUffer.capacity() - pos < 10) {
                return false;
            }
            try {
                TxVer = lBUffer.getShort();
                lId = lBUffer.getShort();
            }
            catch (BufferUnderflowException error) {
                throw new IOException("BADPACKET");
            }
            int VendorID = lBUffer.getInt();
            if (TxVer != 1 || lId != Id || VendorID != 21336) {
                lBUffer.position(pos);
                return false;
            }
            try {
                short PacketLength = lBUffer.getShort();
                return true;
            }
            catch (BufferUnderflowException error) {
                lBUffer.position(pos);
                throw new IOException("BADPACKET");
            }
        }

        private boolean CheckCommand(short Command) {
            short Result;
            short currentType;
            short currentSize;
            int pos = 0;
            pos = this.QBuffer.position();
            try {
                this.QBuffer.position(pos + 2);
            }
            catch (IllegalArgumentException err) {
                this.QBuffer.position(pos);
                return false;
            }
            try {
                currentSize = this.QBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                this.QBuffer.position(pos);
                return false;
            }
            currentSize = (short)(currentSize - 6);
            if (currentSize != 2) {
                this.QBuffer.position(pos);
                return false;
            }
            try {
                currentType = this.QBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                this.QBuffer.position(pos);
                return false;
            }
            if (currentType != 1) {
                this.QBuffer.position(pos);
                return false;
            }
            try {
                Result = this.QBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                this.QBuffer.position(pos);
                return false;
            }
            if (Result == Command) {
                return true;
            }
            this.QBuffer.position(pos);
            return false;
        }

        private boolean CheckCommandInside(ByteBuffer lBUffer, short Command) throws IOException {
            short Result;
            short currentType;
            short currentSize;
            int pos = 0;
            pos = lBUffer.position();
            try {
                lBUffer.position(pos + 2);
            }
            catch (IllegalArgumentException err) {
                throw new IOException("BADPACKET");
            }
            try {
                currentSize = lBUffer.getShort();
            }
            catch (BufferUnderflowException error) {
                throw new IOException("BADPACKET");
            }
            currentSize = (short)(currentSize - 6);
            if (currentSize != 2) {
                throw new IOException("BADPACKET");
            }
            try {
                currentType = lBUffer.getShort();
            }
            catch (BufferUnderflowException error) {
                throw new IOException("BADPACKET");
            }
            if (currentType != 1) {
                throw new IOException("BADPACKET");
            }
            try {
                Result = lBUffer.getShort();
            }
            catch (BufferUnderflowException error) {
                throw new IOException("BADPACKET");
            }
            return Result == Command;
        }

        private short GetPacketLength() {
            int pos = this.OBuffer.position();
            this.OBuffer.position(8);
            short len = this.OBuffer.getShort();
            this.OBuffer.position(pos);
            return len;
        }

        private FramedInfo getFramedTag(CAENRFIDLogicalSource LSource, boolean rssi, boolean tid, boolean compact, boolean xpc) throws CAENRFIDException {
            int pos = 0;
            int status = 0;
            String err = "@ Communication Error";
            String Antenna = "";
            Date TagDate = null;
            byte[] tmp = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            CAENRFIDInPacket InPacket = new CAENRFIDInPacket(tmp);
            boolean exception = false;
            int length = 12;
            short m_rssi = 0;
            byte[] aTID = null;
            byte[] XPC = null;
            short TIDlen = 0;
            boolean TagIsOk = false;
            CAENRFIDProtocol proto = CAENRFIDProtocol.CAENRFID_MULTYPROTOCOL;
            byte[] ID = new byte[]{0, 0};
            CAENRFIDTag Tag = null;
            short pid = CAENRFIDReader.this.Buffer.getAVPPid();
            while (!TagIsOk) {
                if (!exception && (InPacket = CAENRFIDReader.this.Buffer.GetPacket(pid)) == null) {
                    throw new CAENRFIDException("@ Communication Error");
                }
                if (compact && status < 6) {
                    status = 7;
                }
                switch (status) {
                    case 0: {
                        try {
                            pos = InPacket.position();
                            String Source = InPacket.getStringAVP((short)251, 30);
                            if (!Source.equals(LSource.GetName())) {
                                throw new CAENRFIDException("@ Communication Error");
                            }
                            status = 1;
                        }
                        catch (CAENRFIDException err0) {
                            InPacket.position(pos);
                            exception = true;
                            status = 6;
                        }
                        break;
                    }
                    case 1: {
                        try {
                            Antenna = InPacket.getStringAVP((short)34, 5);
                            status = 2;
                            break;
                        }
                        catch (CAENRFIDException err1) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 2: {
                        try {
                            TagDate = new Date(InPacket.getDateAVP((short)16) * 1000);
                            status = 3;
                            break;
                        }
                        catch (CAENRFIDException err2) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 4: {
                        try {
                            length = InPacket.getShortAVP((short)15);
                            status = 5;
                            break;
                        }
                        catch (CAENRFIDException err4) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 3: {
                        try {
                            short TagType = InPacket.getShortAVP((short)18);
                            switch (TagType) {
                                case 0: {
                                    proto = CAENRFIDProtocol.CAENRFID_ISO18000_6b;
                                    break;
                                }
                                case 1: {
                                    proto = CAENRFIDProtocol.CAENRFID_EPC_C1G1;
                                    break;
                                }
                                case 2: {
                                    proto = CAENRFIDProtocol.CAENRFID_ISO18000_6a;
                                    break;
                                }
                                case 3: {
                                    proto = CAENRFIDProtocol.CAENRFID_EPC_C1G2;
                                    break;
                                }
                                case 4: {
                                    proto = CAENRFIDProtocol.CAENRFID_MULTYPROTOCOL;
                                    break;
                                }
                                case 5: {
                                    proto = CAENRFIDProtocol.CAENRFID_EPC119;
                                }
                            }
                            status = 4;
                            break;
                        }
                        catch (CAENRFIDException err3) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 5: {
                        try {
                            pos = InPacket.position();
                            ID = InPacket.getDataAVP((short)17, length);
                            if (rssi) {
                                status = 8;
                            }
                            if (tid) {
                                status = 9;
                            }
                            if (xpc) {
                                status = 11;
                                break;
                            }
                            Tag = new CAENRFIDTag(ID, proto, (short)ID.length, LSource, Antenna);
                            status = 0;
                            break;
                        }
                        catch (CAENRFIDException err5) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 6: {
                        err = InPacket.getAVPStatus();
                        InPacket.position(InPacket.capacity());
                        status = 0;
                        break;
                    }
                    case 7: {
                        try {
                            proto = CAENRFIDProtocol.CAENRFID_EPC_C1G2;
                            Antenna = "Ant0";
                            pos = InPacket.position();
                            ID = InPacket.getDataAVPCompact((short)17);
                            if (rssi) {
                                status = 8;
                                break;
                            }
                            if (tid) {
                                status = 9;
                                break;
                            }
                            if (xpc) {
                                status = 11;
                                break;
                            }
                            Tag = new CAENRFIDTag(ID, proto, (short)ID.length, LSource, Antenna);
                            status = 0;
                        }
                        catch (CAENRFIDException err6) {
                            InPacket.position(pos);
                            exception = true;
                            status = 6;
                        }
                        break;
                    }
                    case 8: {
                        try {
                            m_rssi = InPacket.getShortAVP((short)122);
                            if (tid) {
                                status = 9;
                                break;
                            }
                            if (xpc) {
                                status = 11;
                                break;
                            }
                            Tag = new CAENRFIDTag(ID, proto, (short)ID.length, LSource, Antenna, m_rssi);
                            status = 0;
                            break;
                        }
                        catch (CAENRFIDException err8) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 9: {
                        try {
                            TIDlen = InPacket.getShortAVP((short)80);
                            status = 10;
                            if (TIDlen != 0) break;
                            if (xpc) {
                                status = 11;
                                break;
                            }
                            Tag = new CAENRFIDTag(ID, proto, (short)ID.length, LSource, Antenna, m_rssi, null, TagDate);
                            status = 0;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 10: {
                        try {
                            aTID = InPacket.getDataAVP((short)77, TIDlen);
                            if (xpc) {
                                status = 11;
                                break;
                            }
                            Tag = new CAENRFIDTag(ID, proto, (short)ID.length, LSource, Antenna, m_rssi, aTID, TagDate);
                            status = 0;
                            break;
                        }
                        catch (CAENRFIDException e) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 11: {
                        try {
                            XPC = InPacket.getDataAVP((short)124, 4);
                            Tag = new CAENRFIDTag(ID, proto, (short)ID.length, LSource, Antenna, m_rssi, aTID, XPC, TagDate);
                            status = 0;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                }
                if (status != 0) continue;
                TagIsOk = true;
            }
            boolean rescod = err.equals("Status_OK");
            return new FramedInfo(Tag, rescod);
        }

        private class CAENQueue {
            private LinkedList list = new LinkedList();

            public boolean isEmpty() {
                return this.list.size() == 0;
            }

            public void enqueue(ByteBuffer item) {
                this.list.add(item);
            }

            public ByteBuffer dequeue() {
                ByteBuffer item = (ByteBuffer)this.list.get(0);
                this.list.remove(0);
                return item;
            }

            public ByteBuffer peek() {
                return (ByteBuffer)this.list.get(0);
            }
        }
    }
}

