/*
 * Decompiled with CFR 0.152.
 */
package com.caen.RFIDLibrary;

import com.caen.RFIDLibrary.CAENRFIDException;
import com.caen.RFIDLibrary.CAENRFIDLogicalSource;
import com.caen.RFIDLibrary.CAENRFIDProtocol;
import java.util.Date;

public final class CAENRFIDTag {
    private CAENRFIDLogicalSource LogicalSource;
    private short TagLength;
    private byte[] TagID;
    private byte[] TID;
    private byte[] XPC;
    private CAENRFIDProtocol proto;
    private String TReadPoint = "Not Available";
    private Date TimeStamp = null;
    private short m_rssi = 0;

    public CAENRFIDTag(byte[] Id, short length, CAENRFIDLogicalSource Source) throws CAENRFIDException {
        if (Id.length > 64) {
            throw new CAENRFIDException("@ Invalid Tag");
        }
        this.LogicalSource = Source;
        this.TagLength = length;
        this.TagID = new byte[this.TagLength];
        this.TID = null;
        System.arraycopy(Id, 0, this.TagID, 0, this.TagLength);
        this.proto = CAENRFIDProtocol.CAENRFID_MULTYPROTOCOL;
    }

    public CAENRFIDTag(byte[] Id, short length, CAENRFIDLogicalSource Source, String ReadPoint) throws CAENRFIDException {
        if (Id.length > 64) {
            throw new CAENRFIDException("@ Invalid Tag");
        }
        this.LogicalSource = Source;
        this.TagLength = length;
        this.TReadPoint = ReadPoint;
        this.TagID = new byte[this.TagLength];
        this.TID = null;
        System.arraycopy(Id, 0, this.TagID, 0, this.TagLength);
        this.proto = CAENRFIDProtocol.CAENRFID_MULTYPROTOCOL;
    }

    protected CAENRFIDTag(byte[] Id, CAENRFIDProtocol type, short length, CAENRFIDLogicalSource Source, String ReadPoint) throws CAENRFIDException {
        if (Id.length > 64) {
            throw new CAENRFIDException("@ Invalid Tag");
        }
        this.LogicalSource = Source;
        this.TagLength = length;
        this.TReadPoint = ReadPoint;
        this.TagID = new byte[this.TagLength];
        this.TID = null;
        System.arraycopy(Id, 0, this.TagID, 0, this.TagLength);
        this.proto = type;
    }

    protected CAENRFIDTag(byte[] Id, CAENRFIDProtocol type, short length, CAENRFIDLogicalSource Source, String ReadPoint, Date timestamp) throws CAENRFIDException {
        if (Id.length > 64) {
            throw new CAENRFIDException("@ Invalid Tag");
        }
        this.LogicalSource = Source;
        this.TagLength = length;
        this.TReadPoint = ReadPoint;
        this.TagID = new byte[this.TagLength];
        System.arraycopy(Id, 0, this.TagID, 0, this.TagLength);
        this.TID = null;
        this.proto = type;
        this.TimeStamp = timestamp;
    }

    protected CAENRFIDTag(byte[] Id, CAENRFIDProtocol type, short length, CAENRFIDLogicalSource Source, String ReadPoint, short rssi) throws CAENRFIDException {
        if (Id.length > 64) {
            throw new CAENRFIDException("@ Invalid Tag");
        }
        this.LogicalSource = Source;
        this.TagLength = length;
        this.TReadPoint = ReadPoint;
        this.TagID = new byte[this.TagLength];
        System.arraycopy(Id, 0, this.TagID, 0, this.TagLength);
        this.TID = null;
        this.proto = type;
        this.m_rssi = rssi;
    }

    protected CAENRFIDTag(byte[] Id, CAENRFIDProtocol type, short length, CAENRFIDLogicalSource Source, String ReadPoint, short rssi, byte[] tTID) throws CAENRFIDException {
        if (Id.length > 64) {
            throw new CAENRFIDException("@ Invalid Tag");
        }
        this.LogicalSource = Source;
        this.TagLength = length;
        this.TReadPoint = ReadPoint;
        this.TagID = new byte[this.TagLength];
        System.arraycopy(Id, 0, this.TagID, 0, this.TagLength);
        if (tTID != null) {
            this.TID = new byte[tTID.length];
            System.arraycopy(tTID, 0, this.TID, 0, tTID.length);
        } else {
            this.TID = null;
        }
        this.proto = type;
        this.m_rssi = rssi;
    }

    protected CAENRFIDTag(byte[] Id, CAENRFIDProtocol type, short length, CAENRFIDLogicalSource Source, String ReadPoint, short rssi, byte[] tTID, Date time) throws CAENRFIDException {
        if (Id.length > 64) {
            throw new CAENRFIDException("@ Invalid Tag");
        }
        this.LogicalSource = Source;
        this.TagLength = length;
        this.TReadPoint = ReadPoint;
        this.TagID = new byte[this.TagLength];
        System.arraycopy(Id, 0, this.TagID, 0, this.TagLength);
        if (tTID != null) {
            this.TID = new byte[tTID.length];
            System.arraycopy(tTID, 0, this.TID, 0, tTID.length);
        } else {
            this.TID = null;
        }
        this.proto = type;
        this.m_rssi = rssi;
        this.TimeStamp = time;
    }

    protected CAENRFIDTag(byte[] Id, CAENRFIDProtocol type, short length, CAENRFIDLogicalSource Source, String ReadPoint, short rssi, byte[] tTID, byte[] tXPC, Date time) throws CAENRFIDException {
        if (Id.length > 64) {
            throw new CAENRFIDException("@ Invalid Tag");
        }
        this.LogicalSource = Source;
        this.TagLength = length;
        this.TReadPoint = ReadPoint;
        this.TagID = new byte[this.TagLength];
        System.arraycopy(Id, 0, this.TagID, 0, this.TagLength);
        if (tTID != null) {
            this.TID = new byte[tTID.length];
            System.arraycopy(tTID, 0, this.TID, 0, tTID.length);
        } else {
            this.TID = null;
        }
        this.proto = type;
        this.m_rssi = rssi;
        this.TimeStamp = time;
        this.XPC = tXPC;
    }

    public byte[] GetId() {
        return this.TagID;
    }

    public byte[] GetTID() {
        return this.TID;
    }

    public short GetLength() {
        return this.TagLength;
    }

    public short GetRSSI() {
        return this.m_rssi;
    }

    public CAENRFIDLogicalSource GetSource() {
        return this.LogicalSource;
    }

    public CAENRFIDProtocol GetType() {
        return this.proto;
    }

    public Date GetTimeStamp() {
        return this.TimeStamp;
    }

    public String GetAntenna() {
        return this.TReadPoint;
    }

    public byte[] GetXPC() {
        return this.XPC;
    }

    public String GetReadPoint() throws CAENRFIDException {
        if (this.TReadPoint.equals("")) {
            throw new CAENRFIDException("@ ReadPoint not available");
        }
        return this.TReadPoint;
    }
}

