/*
 * Decompiled with CFR 0.152.
 */
package com.caen.RFIDLibrary;

import com.caen.RFIDLibrary.CAENRFIDChannel;
import com.caen.RFIDLibrary.CAENRFIDException;
import com.caen.RFIDLibrary.CAENRFIDLogicalSource;
import com.caen.RFIDLibrary.CAENRFIDReader;

public final class CAENRFIDTrigger {
    private String Nome;
    private int time;
    private int IOLine = 99;
    private boolean ValidTrigger;
    private CAENRFIDReader MainReader;

    protected CAENRFIDTrigger(CAENRFIDReader Reader, String nome, int Timer) {
        this.Nome = nome;
        this.time = Timer;
        this.MainReader = Reader;
        this.ValidTrigger = true;
    }

    protected CAENRFIDTrigger(CAENRFIDReader Reader, String nome, int LineIO, int Timer) {
        this.Nome = nome;
        this.time = Timer;
        this.IOLine = LineIO;
        this.MainReader = Reader;
        this.ValidTrigger = true;
    }

    public String GetName() throws CAENRFIDException {
        if (!this.ValidTrigger) {
            throw new CAENRFIDException("Invalid Object");
        }
        return this.Nome;
    }

    public int GetIOLineValue() throws CAENRFIDException {
        if (!this.ValidTrigger) {
            throw new CAENRFIDException("Invalid Object");
        }
        if (this.IOLine != 99) {
            return this.IOLine;
        }
        throw new CAENRFIDException("Not IO Trigger");
    }

    public int GetTimerValue() throws CAENRFIDException {
        if (!this.ValidTrigger) {
            throw new CAENRFIDException("Invalid Object");
        }
        return this.time;
    }

    protected void Deallocate() {
        this.ValidTrigger = false;
    }

    public boolean IsLinkedToChannel(CAENRFIDChannel Channel2) throws CAENRFIDException {
        short Result;
        if (!this.ValidTrigger) {
            throw new CAENRFIDException("Invalid Object");
        }
        try {
            Result = this.MainReader.CheckChannelInTrigger(this.Nome, Channel2.GetName());
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        return Result == 1;
    }

    public boolean IsLinkedToSource(CAENRFIDLogicalSource Source) throws CAENRFIDException {
        short Result;
        if (!this.ValidTrigger) {
            throw new CAENRFIDException("Invalid Object");
        }
        try {
            Result = this.MainReader.CheckSourceInTrigger(this.Nome, Source.GetName());
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        return Result == 1;
    }
}

