/*
 * Decompiled with CFR 0.152.
 */
package java.nio.buffers;

public class ByteBuffer {
    private byte[] m_buffer = null;
    private int m_position = 0;

    protected ByteBuffer(int capacity) {
        this.m_buffer = new byte[capacity];
    }

    protected ByteBuffer(byte[] array) {
        this.m_buffer = new byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            this.m_buffer[i] = array[i];
        }
    }

    public ByteBuffer() {
    }

    public ByteBuffer putShort(short value) {
        byte[] new_array = new byte[]{(byte)((value & 0xFF00) >> 8), (byte)(value & 0xFF)};
        System.arraycopy(new_array, 0, this.m_buffer, this.m_position, new_array.length);
        this.m_position += new_array.length;
        return this;
    }

    public ByteBuffer putInt(int value) {
        byte[] new_array = new byte[]{(byte)((value & 0xFF000000) >> 24), (byte)((value & 0xFF0000) >> 16), (byte)((value & 0xFF00) >> 8), (byte)(value & 0xFF)};
        System.arraycopy(new_array, 0, this.m_buffer, this.m_position, new_array.length);
        this.m_position += new_array.length;
        return this;
    }

    public int position() {
        return this.m_position;
    }

    public ByteBuffer position(int newPosition) {
        if (newPosition < 0 || newPosition > this.m_buffer.length) {
            return this;
        }
        this.m_position = newPosition;
        return this;
    }

    public static ByteBuffer allocate(int capacity) {
        return new ByteBuffer(capacity);
    }

    public boolean hasArray() {
        return this.m_buffer != null;
    }

    public byte[] array() {
        return this.m_buffer;
    }

    public static ByteBuffer wrap(byte[] array) {
        return new ByteBuffer(array);
    }

    public int capacity() {
        return this.m_buffer.length;
    }

    public ByteBuffer rewind() {
        this.m_position = 0;
        return this;
    }

    public short getShort() {
        char anUnsignedShort = '\u0000';
        int firstByte = 0;
        int secondByte = 0;
        if (this.m_position + 1 > this.capacity()) {
            anUnsignedShort = '\u0000';
        }
        firstByte = 0xFF & this.m_buffer[this.m_position];
        secondByte = 0xFF & this.m_buffer[this.m_position + 1];
        anUnsignedShort = (char)(firstByte << 8 | secondByte);
        this.m_position += 2;
        return (short)anUnsignedShort;
    }

    public int getInt() {
        long anUnsignedInt = 0L;
        int firstByte = 0;
        int secondByte = 0;
        int thirdByte = 0;
        int fourthByte = 0;
        if (this.m_position + 3 > this.capacity()) {
            anUnsignedInt = 0L;
        }
        firstByte = 0xFF & this.m_buffer[this.m_position];
        secondByte = 0xFF & this.m_buffer[this.m_position + 1];
        thirdByte = 0xFF & this.m_buffer[this.m_position + 2];
        fourthByte = 0xFF & this.m_buffer[this.m_position + 3];
        anUnsignedInt = (long)(firstByte << 24 | secondByte << 16 | thirdByte << 8 | fourthByte) & 0xFFFFFFFFL;
        this.m_position += 4;
        return (int)anUnsignedInt;
    }

    public int getLong() {
        long anUnsignedInt = 0L;
        int firstByte = 0;
        int secondByte = 0;
        int thirdByte = 0;
        int fourthByte = 0;
        if (this.m_position + 3 > this.capacity()) {
            anUnsignedInt = 0L;
        }
        firstByte = 0xFF & this.m_buffer[this.m_position];
        secondByte = 0xFF & this.m_buffer[this.m_position + 1];
        thirdByte = 0xFF & this.m_buffer[this.m_position + 2];
        fourthByte = 0xFF & this.m_buffer[this.m_position + 3];
        anUnsignedInt = (long)(firstByte << 24 | secondByte << 16 | thirdByte << 8 | fourthByte) & 0xFFFFFFFFL;
        this.m_position += 4;
        return (int)anUnsignedInt;
    }

    public ByteBuffer put(byte b) {
        this.m_buffer[this.m_position++] = b;
        return this;
    }

    public ByteBuffer put(byte[] src) {
        System.arraycopy(src, 0, this.m_buffer, this.m_position, src.length);
        this.m_position += src.length;
        return this;
    }

    public ByteBuffer get(byte[] dst, int offset, int length) {
        System.arraycopy(this.m_buffer, this.m_position, dst, offset, length);
        this.m_position += length;
        return this;
    }
}

